﻿/// <binding BeforeBuild='runAll' ProjectOpened='setWatch' />
/*
This file in the main entry point for defining Gulp tasks and using Gulp plugins.
Click here to learn more. http://go.microsoft.com/fwlink/?LinkId=518007
*/

var gulp = require("gulp");
var concat = require("gulp-concat");
var zip = require("gulp-zip");
var templateCache = require("gulp-angular-templatecache");
var fs = require('fs');
var path = require('path');
var rename = require('gulp-rename');
var sass = require("gulp-sass");
var uglify = require('gulp-uglify');

var stripDir = function (p) { p.dirname = ''; };
var rootFolder = { app: './App/', appAdmi: './App_Admin/', dist: './Dist/'};
function getFolders(dir) {
    return fs.readdirSync(dir)
        .filter(function (file) {
            return fs.statSync(path.join(dir, file)).isDirectory();
        });
}

var cfg = {    
    templates: {
        src: [rootFolder.app + '**/*.html'],
        dest: rootFolder.dist,        
        moduleName: 'WizdomMobileModule',
        root: 'WizdomMobileModule/App/'
    },
    css: {
        src: [
            './App/**/*.css',
            '!./App/**/*.min.css'
        ],
        dest: rootFolder.dist,
        file: 'style.css'
    },
    js: {
        src: ['./App/**/*.js', './Dist/templates.js'],
        dest: rootFolder.dist,
        file: 'app.js'
    },
    adminJs: {
        src: ['./App_Admin/**/*.js', './Dist/adminTemplates.js'],
        dest: rootFolder.dist,
        file: 'adminApp.js'
    },
    adminTemplates: {
        src: ['./App_Admin/**/*.html'],
        dest: rootFolder.dist,
        moduleName: 'WizdomMobileModule',
        root: 'WizdomMobileModule/App_Admin/',
        file: 'adminTemplates.js'
    },
    adminCss: {
        src: [
            './App_Admin/**/*.css',
            './App_Admin/**/*.min.css'
        ],
        dest: rootFolder.dist,
        file: 'adminStyle.css'
    },
};

gulp.task('compileTemplates', function CompileTemplates() {
    return gulp.src(cfg.templates.src)
        .pipe(templateCache({
            root: cfg.templates.root,
            module: cfg.templates.moduleName
        }))
        .pipe(gulp.dest(cfg.templates.dest));   
});

gulp.task('compileAdminTemplates', function CompileAdminTemplates() {
    return gulp.src(cfg.adminTemplates.src)
        .pipe(templateCache({
            root: cfg.adminTemplates.root,
            module: cfg.adminTemplates.moduleName,
            filename: cfg.adminTemplates.file
        }))
        .pipe(gulp.dest(cfg.adminTemplates.dest));
});

gulp.task('compile-scss-admin', function () {
    return gulp.src('./App_Admin/Styles/Master.scss')
        .pipe(sass({ outputStyle: 'expanded', indentType: 'tab', indentWidth: '1' }).on('error', sass.logError))
        .pipe(rename(stripDir))
        .pipe(gulp.dest('./App_Admin/Styles/'));
});

gulp.task('compile-scss-app', function () {
        return gulp.src('./App/Styles/Master.scss')
            .pipe(sass({ outputStyle: 'expanded', indentType: 'tab', indentWidth: '1' }).on('error', sass.logError))
            .pipe(rename(stripDir))
            .pipe(gulp.dest('./App/Styles/'));
});

gulp.task('concatCss', ['compile-scss-app'], function ConcatCss() {
    return gulp.src(cfg.css.src)
      .pipe(concat({ path: cfg.css.file }))
      .pipe(gulp.dest(cfg.css.dest));
});

gulp.task('concatAdminCss', ['compile-scss-admin'], function ConcatAdminCss() {
    return gulp.src(cfg.adminCss.src)
        .pipe(concat({ path: cfg.adminCss.file }))
        .pipe(gulp.dest(cfg.adminCss.dest));
});

gulp.task('concatJs', function ConcatJs() {
    return gulp.src(cfg.js.src)
      .pipe(concat({ path: cfg.js.file }))      
      .pipe(gulp.dest(cfg.js.dest));
});

gulp.task('compressJs', ['concatJs'], function compressJs() {
    return gulp.src(cfg.js.src)
        .pipe(concat({ path: 'app.min.js' }))
        .pipe(uglify())
        .pipe(gulp.dest(cfg.js.dest));
});


gulp.task('concatAdminJs', function concatAdminJs() {
    return gulp.src(cfg.adminJs.src)
        .pipe(concat({ path: cfg.adminJs.file }))
        .pipe(gulp.dest(cfg.adminJs.dest));
});


gulp.task('zipBlobFiles', function ZipBlobFiles() {
    return gulp.src('./WizdomBlob/**').pipe(zip('WizdomMobileModule.zip')).pipe(gulp.dest(rootFolder.dist));
});

gulp.task('runAll', function () {
    // place code for your default task here
    gulp.start([		
        "compileTemplates",
        "compileAdminTemplates",
        "concatCss",
        "concatAdminCss",
        "concatJs",
        "concatAdminJs",
        "zipBlobFiles"
    ]);    
});

gulp.task('setWatch', function () {
    gulp.watch(['App/**/*.js'], ['concatJs']);
    gulp.watch(cfg.adminJs.src, ['concatAdminJs']);
    gulp.watch(['App/**/*.scss'], ['concatCss']);
    gulp.watch(['App_Admin/**/*.css'], ['concatAdminCss']);
    gulp.watch(['App/**/*.html'], ['compileTemplates', 'concatJs']);
    gulp.watch(['./App_Admin/**/*.html'], ['compileAdminTemplates', 'concatAdminJs']);
    gulp.watch(['WizdomBlob/**'], ['zipBlobFiles']);
});