﻿(function () {
    angular.module("WizdomMobileModule").factory("clientStorageService", clientStorageService);

    clientStorageService.$inject = ["$window", "$document"];

    function clientStorageService($window, $document) {
        return { session: getObj(window.sessionStorage, 'session'), local: getObj(window.localStorage, 'local') };
    };

    function getObj(storage, sType) {
        return {
            storageType: sType,
            setItem: function (key, value, expiresAt) {
                setItem(storage, key, value, expiresAt);
            },
            removeItem: function (key) {
                removeItem(storage, key);
            },
            getItem: function (key) {
                var k = getKey(key);
                return getItem(storage, k);
            },
            clear: function (pattern) {
                return clear(storage, pattern);
            },
            isExpired: function (key) {
                return isExpired(storage, key);
            },
            getExpireTime: function (key) {
                return getExpireTime(storage, key);
            },
            expiresIn: function (key) {
                return expiresIn(storage, key);
            },
            testExpires: function (key) {
                return testExpires(storage, key);
            },
            hasStorage: function (pattern) {
                return hasStorage(storage, pattern);
            },
            expiresInToMinutes: function (expiresIn) {
                return (expiresIn / 60000);
            },
            addMinutesToNow: function (minutes) {
                return new Date(new Date().getTime() + (minutes * 60000));
            }
        };

    }

    // helper functions
    function getExpireTime(storage, cacheKey) {
        var rval = 0;
        var k = getKey(cacheKey) + '_At';
        var expiresAt = storage.getItem(k);
        if (expiresAt != null) {
            rval = expiresAt;
        }
        return rval;
    }
    function expiresIn(storage, cacheKey) {
        var expireTime = getExpireTime(storage, cacheKey)
        return expiresInDiff(expireTime);
    }
    function expiresInDiff(expireTime) {
        if (expireTime == 0) { return expireTime; }
        var now = new Date().getTime();
        return expireTime - now;
    }
    function isExpired(storage, cacheKey) {
        return (expiresIn(storage, cacheKey) < 0);
    }
    function setItem(storage, key, value, expiresAt) {
        if (angular.isUndefined(value)) { value = null; }
        if (angular.isUndefined(expiresAt)) { expiresAt = 0; }
        var k = getKey(key);
        storage.setItem(k, value);
        if (expiresAt > 0) {
            storage.setItem(k + '_At', expiresAt);
        }
    }
    function getItem(storage, key) {
        var k = getKey(key);
        if (isExpired(storage, key)) {
            removeItem(storage, key);
            return null;
        }
        return storage.getItem(k);
    }
    function clear(storage, pattern) {
        if (angular.isUndefined(pattern)) {
            pattern = '';
        }
        var prefix = getKey(pattern), rval = 0;
        for (var obj in storage) {
            if (storage.hasOwnProperty(obj) && (obj.indexOf(prefix) == 0)) {
                storage.removeItem(obj);
                rval++;
            }
        }
        return rval;
    }
    function hasStorage(storage, pattern) {
        if (angular.isUndefined(pattern)) {
            pattern = '';
        }
        var prefix = getKey(pattern), rval = false;
        for (var obj in storage) {
            if (storage.hasOwnProperty(obj) && (obj.indexOf(prefix) == 0)) {
                rval = true;
                break;
            }
        }
        return rval;
    }
    function removeItem(storage, key) {
        var k = getKey(key);
        storage.removeItem(k);
        storage.removeItem(k + '_At');
    }
    function getKey(key) {
        if (key.indexOf("wiz_") < 0) {
            return "wiz_" + key;
        }
        return key;
    }

    //test functions
    function testExpires(storage, key) {
        var now = new Date().getTime(),
            expiresAt = getExpireTime(storage, key);

        window.console && window.console.log('expiresAt:' + expiresAt + ' now:' + now + ' key:' + key);
        var brdInterval = setInterval(function () {
            var diff = expiresInDiff(expiresAt);
            var diff_as_date = new Date(diff);
            window.console && window.console.log('diff:' + diff + ' h:' + diff_as_date.getHours() + ' m:' + diff_as_date.getMinutes() + ' s:' + diff_as_date.getSeconds());
            if (diff < 0) {
                clearInterval(brdInterval);
            }
        }, 1000);
    }
    /*
        Date.prototype.addMinutes = function (minutes) {
            var copiedDate = new Date(this.getTime());
            return new Date(copiedDate.getTime() + minutes * 60000);
        }
    */
})();