﻿(function () {
    angular.module("WizdomMobileModule").factory("wcmStarterSettingsApi", wcmStarterSettingsApi);

    wcmStarterSettingsApi.$inject = ["$q", "wcmStarterHttpApi", "clientStorageService", "$timeout"];

    var stgs = {}, module = 'WizdomMobileModule';

    function wcmStarterSettingsApi($q, wcmStarterHttpApi, storageService, $timeout) {
        var storage = storageService.local, cacheKey = 'wcmsModuleSgts', expiresInMinutes = 7200; //5 days for caching
        var baseUrl = '/api/wcmStartersettings/';


        function getAppSettings() {
            // If value is cached return it, if not fetch it and cache it when it gets here before handing it over
            return stgs[module] ? $q.when(stgs[module]) : wcmStarterHttpApi.getCached(baseUrl + module).then(function (data) {
                stgs[module] = data;
                return stgs[module];
            });

        }

        function getModuleSettings(getCached) {
            var deferred = $q.defer(), getFromServer = false;
            if (angular.isUndefined(getCached)) { getCached = false; }
            if (getCached) {
                var cachedValue = storage.getItem(cacheKey);
                var stgs = JSON.parse(cachedValue);
                if (stgs) {
                    getLastModifiedTime().then(function (datetime) {
                        var lastCacheReset = new Date(datetime);
                        if ((lastCacheReset.getTime() + (expiresInMinutes * 60000)) > (parseInt(storage.getExpireTime(cacheKey)))) {
                            storage.setItem(cacheKey, null); /*cache as it been reset on the server*/
                        }
                    });
                    $timeout(function () { deferred.resolve(stgs); }, 0);
                } else {
                    getFromServer = true;
                }
            } else {
                getFromServer = true;
            }
            if (getFromServer) {
                getAppSettings().then(function (stg) {
                    if (getCached) {
                        var expiresAt = storage.addMinutesToNow(expiresInMinutes).getTime();
                        storage.setItem(cacheKey, JSON.stringify(stg.moduleSettings), expiresAt);
                    }
                    deferred.resolve(stg.moduleSettings);
                }, function () {
                    var errMsg = "Error. Could not get CCCustomModule settings";
                    deferred.reject(errMsg);
                });
            }
            return deferred.promise;
        }

        function getFromCacheFn() {
            var cachedValue = storage.getItem(cacheKey);
            if (cachedValue) {
                return JSON.parse(cachedValue);
            }
            return null;
        }
        function saveModuleSettings(settings) {
            if (stgs[module]) {
                stgs[module].ModuleSettings = settings; /* Update cached settings */
            }
            wcmStarterHttpApi.resetCache(baseUrl + module);
            return wcmStarterHttpApi.post(baseUrl + module, settings);
        }

        function getLastResetTime() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/lastreset/');
        }
        function getLastModifiedTime() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/lastmodified/');
        }

        function initCache() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/initcache/');
        }

        function getCurrentUser() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/currentuser/');
        }

        var service = {
            getSettings: getModuleSettings,
            saveSettings: saveModuleSettings,
            getAppSettings: getAppSettings,
            initCache: initCache,
            getCurrentUser: getCurrentUser,
            getFromCache: getFromCacheFn,
        };

        return service;
    }
})();