﻿(function () {
    angular.module("WizdomMobileModule").factory("administrationApi", administrationApi);

    administrationApi.$inject = ["$q", "wcmStarterHttpApi"];

    function administrationApi($q, httpApi) {
        var baseUrl = '/api/administration/';

        function getPagesTree() {
            return httpApi.get(baseUrl + 'gettree');
        }
        var service = {
            pagesTree: getPagesTree,
            install: function (processId) {
                return httpApi.post(baseUrl + 'install/' + processId);
            },
            createWizdomProject: function (processId, wizdomProject) {
                return httpApi.post('/api/wizdomproject/create/' + processId, wizdomProject);
            },
            createSpSite: function (processId, siteId) {
                return httpApi.post('/api/wizdomproject/spsite/' + siteId + '/' + processId + '/');
            },
            getProjectStatus: function (processId) {
                return httpApi.get('/api/wizdomproject/status/' + processId);
            },
            getNewVersionAvailable: function () {
                return httpApi.get(baseUrl + 'getnewversionavailable');
            },
            getModuleVersion: function () {
                return httpApi.get(baseUrl + 'getmoduleversion');
            },
            installWizdom: function (processId, url) {
                return httpApi.post('/api/wizdomproject/installwizdom/' + processId + '?url=' + encodeURIComponent(url));
            },
            resetcache: function () {
                return httpApi.get(baseUrl + 'resetcache');
            },
            initCache: function (sourceUrl, destinationUrl, contentTypeIdentifier) {
                return httpApi.get(baseUrl + 'initcache/?sourceUrl=' + encodeURIComponent(sourceUrl) + '&destinationUrl=' + encodeURIComponent(destinationUrl) + '&contentTypeIdentifier=' + encodeURIComponent(contentTypeIdentifier));
            },
            callLogOperation: function (processId) {
                return httpApi.get(baseUrl + 'logoperation/' + processId);
            },
            getApplyError: function (processId) {
                return httpApi.get(baseUrl + 'error/' + processId);
            },
            getApplyStatus: function (processId) {
                return httpApi.get(baseUrl + 'status/' + processId);
            },
            testWebHook: function () {
                return httpApi.post('/api/webhook/wizdomsitecreated');
            },
            getLogs: function (wizdomModule) {
                if (!wizdomModule) { wizdomModule = "";}
                return httpApi.get("/api/wcmStarterlog?module=" + wizdomModule);
            },
            clearLog: function (wizdomModule) {
                if (!wizdomModule) { wizdomModule = ""; }
                return httpApi.delete("/api/wcmStarterlog?module=" + wizdomModule);
            },
            getCourseManagementInstances: function () {
                return httpApi.get("/api/wizdomproject/coursemanagementinstances");
            },
            getSettings: function () {
                return httpApi.get(baseUrl + 'GetSettings');
            },
            saveSettings: function (settings) {
                return httpApi.post(baseUrl + 'SaveSettings', settings);
            }
        };
        
        return service;
    }
})();