﻿(function () {
    angular.module("WizdomMobileModule").controller("translationsAdminController", translationsAdminController);
    translationsAdminController.$inject = ["$scope","wcmStarterHttpApi" ,"webApiProxy", "contextInfo"];
    function translationsAdminController($scope, httpApi ,webApiProxy, contextInfo) {
        var vm = this;

        //public methods
        vm.getTranslation = getTranslation;
        vm.postTranslationFile = postTranslationFile;
        vm.defaultTranslations = [];
        vm.loading = false;
        vm.dataReady = false;
        vm.translationsObj = {};

        vm.availableTranslations = [];

        function getTranslation(languageCode) {
            httpApi.get(contextInfo.appUrl + '/api/translations/' + languageCode).then(function (response) {
                vm.translationsObj = response;
                vm.dataReady = true;
            });
        }

        function postTranslationFile(languageCode) {
            vm.loading = true;
            getTranslation(languageCode);
            webApiProxy.translations.uploadTranslationFile(languageCode, JSON.stringify(vm.translationsObj)).then(function () {
                vm.loading = false;
            });
        }

        function getTranslations() {
            httpApi.get(contextInfo.appUrl + '/api/translations/translationsfiles').then(function (response) {
                vm.availableTranslations = response;
            });
        }

        function init() {
            getTranslations();
        }
        init();
    }

})();