﻿(function () {

    angular.module("WizdomMobileModule").controller("settingsController", settingsController);

    settingsController.$inject = ["$scope", "wcmStarterSettingsApi", "wcmStarterHttpApi", "administrationApi", "$timeout"];

    function settingsController($scope, wcmStarterSettingsApi, httpApi, administrationApi, $timeout) {
        var emptyWfSite = { title: '', url: '', admins: [] };
        var emptyCmSite = { instanceName: '', instanceId: 0, signupRoleName: 'W365CM_Participants', defaultPageUrl: '/Sider/course_details.aspx?course='};
        $scope.newCmSite = angular.copy(emptyCmSite);
        $scope.saving = false;
        $scope.addingNewSite = false;
        $scope.selectedInstance = null;
        $scope.appInstances = {};

        var stg = { helpdeskMail: '', addGetHelpLinkToTopPanel:false };
        $scope.stg = stg;
        function init() {
            administrationApi.getCourseManagementInstances().then(function (instances) {
                $scope.appInstances = instances;
            });
            //wcmStarterSettingsApi.getSettings().then(function (stg) {
            //    $scope.stg = stg;
            //    if (!$scope.stg.sitesWithIntegration) {
            //        $scope.stg.sitesWithIntegration = [];
            //        $scope.stg.sitesWithIntegration.push(angular.copy(emptyCmSite));
            //    }
            //});
        }

        $timeout(init, 0);
        
        $scope.saveConfig = function () {
            $scope.saving = true;
            wcmStarterSettingsApi.saveSettings($scope.stg).then(
                function () {
                    $scope.saving = false;
                }
          )
        };

        $scope.addPrincipal = function (principal) {
        }
        $scope.removePrincipal = function (principal) {
        }

        $scope.deleteSite = function (index) {
            $scope.stg.sitesWithIntegration.splice(index, 1);
        }

        $scope.addNewSite = function () {
            $scope.addingNewSite = true;
        }
        $scope.cancel = function () {
            resetNewCmSiteSites();
        }
        $scope.saveNewSite = function () {
            if (!$scope.stg.sitesWithIntegration) { $scope.stg.sitesWithIntegration = []; }
            $scope.instanceChanged();
            if ($scope.newCmSite.instanceId > 0) {
                $scope.stg.sitesWithIntegration.push($scope.newCmSite);
            }
            resetNewCmSiteSites();
        }

        $scope.instanceChanged = function () {
            var instance = $scope.selectedInstance;
            if (instance != null) {
                $scope.newCmSite.instanceName = instance.name;
                $scope.newCmSite.instanceId = instance.id;
            }
        }

        function resetNewCmSiteSites() {
            $scope.selectedInstance = null;
            $scope.addingNewSite = false;
            $scope.newCmSite = emptyCmSite;
        }



    }
})();