﻿(function () {

    angular.module("WizdomMobileModule").controller("HomeAdminController", HomeAdminController);
    HomeAdminController.$inject = ["$scope", "$timeout", "settingsApi", "noticeboardService"];
    function HomeAdminController($scope, $timeout, settingsApi, noticeboardService) {
        var vm = this;

        settingsApi.getSettings('NewsLatest').then(function (response) {
            vm.latestNewsSettings = response;
        });

        settingsApi.getSettings('NewsNoticeboard').then(function (response) {
            vm.noticeboardSettings = response;
        });

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };

        vm.saveNoticeboardViewConfiguration = function () {
            var data = {
                "id": "84fefad3-79b9-41fe-b650-4fc9abd1c1b1",
                "channelSetId": vm.noticeboardSettings.channelSetId,
                "deviceId": 1,
                "deviceIdentifier": "Webpart",
                "sharedChannelSet": true,
                "extendedProperties": {
                    "itemsPerPage": vm.noticeboardSettings.homeItemsPerPage || 3,
                    "maxNumberOfPages": 1, //vm.noticeboardSettings.maxNumberOfPages,
                    "defaultSelection": "All",
                    "hideToolbar": false,
                    "archiveUrl": null,
                    "overviewTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/Overview/WizdomMobileModule_Overview_Default.html",
                    "showItemTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/ShowItem/WizdomMobileModule_Show_Default.html",
                    "createEditNewsTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/NewEditForm/WizdomMobileModule_CreateAndEdit.html",
                    "createEditVideoTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/NewEditForm/WizdomMobileModule_CreateAndEdit.html"
                },
                "editAllowedForCurrentUser": false
            };
            noticeboardService.getViewById('84fefad3-79b9-41fe-b650-4fc9abd1c1b1').then(function (response) {
                if (response.views.count > 0) {
                    // update existing view
                    noticeboardService.putViewById('84fefad3-79b9-41fe-b650-4fc9abd1c1b1', data);
                }
                else {
                    // create new view
                    noticeboardService.postViewById('84fefad3-79b9-41fe-b650-4fc9abd1c1b1', data);
                }
            });

        }

    }

})();