﻿(function () {

    angular.module("WizdomMobileModule").controller("welcomeAdminController", welcomeAdminController);

    welcomeAdminController.$inject = ['settingsApi', '$timeout', '$window'];

    function welcomeAdminController(settingsApi, $timeout, $window) {
        var vm = this;

        // Properties 
        vm.welcomeTypeOptions = ["Personal banner", "Custom banner"];

        // Public methods
        vm.welcomeBannerEnabled = welcomeBannerEnabled;
        vm.chosenType = chosenType;

        // Get settings 
        settingsApi.getSettings('Welcome').then(function (response) {
            vm.settings = response;
            vm.settings.customEnabled = false;
            vm.settings.imageStyle = vm.settings.imageStyle || {
                height: '150',
                width: '150',
                objectFitArr: ['fill', 'contain', 'cover', 'scale-down', 'none']
            };
        });

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
            });
        };

        function welcomeBannerEnabled() {
            vm.saveSettings();
        }

        function chosenType(selectedType) {
            vm.settings.selectedType = selectedType;
        }
    }
})();