﻿(function () {

    angular.module("WizdomMobileModule").controller("pushController", pushController);
    pushController.$inject = ["$scope", "pushRegistrationsService"];
    function pushController($scope, pushRegistrationsService) {
        var vm = this;

        // Properties
        vm.globalPushEvents = [];

        // Public methods
        vm.eventTypeChecked = eventTypeChecked;
        vm.toggleEventState = toggleEventState;

        /**
         * Initializes the application
         * */
        function initialize() {
            // Get default event settings
            pushRegistrationsService.getGlobalPushEventDefaults().then(function (response) {
                vm.globalPushEvents = response || [];
            });
        }
        initialize();

        function eventTypeChecked(eventTypeArr) {
            exists = false;
            for (var i = 0; i < eventTypeArr.length; i++) {
                if (typeof vm.globalPushEvents[eventTypeArr[i]] !== 'undefined') {
                    if (vm.globalPushEvents[eventTypeArr[i]] === true) exists = true;
                }
            }
            return exists;
        }

        function toggleEventState(event, removeEventsArr) {

            // Check to add or update current event type
            if (event !== null) {
                if (typeof vm.globalPushEvents[event] !== 'undefined') {
                    vm.globalPushEvents[event] = vm.globalPushEvents[event] = !vm.globalPushEvents[event];
                }
            }

            // Check to disable related events
            if (removeEventsArr !== null) {
                for (var i = 0; i < removeEventsArr.length; i++) {
                    vm.globalPushEvents[removeEventsArr[i]] = false;
                }
            }

            pushRegistrationsService.setGlobalPushEventDefaults(vm.globalPushEvents).then(function (response) {
                console.log(response);
            });
        }
    }

})();