﻿(function () {

    angular.module("WizdomMobileModule").controller("pushCorporateNewsController", pushCorporateNewsController);
    pushCorporateNewsController.$inject = ["$scope", "$window", "$q", "settingsApi", "wcmStarterHttpApi"];
    function pushCorporateNewsController($scope, $window, $q, settingsApi, httpApi ) {
        var vm = this;

        // Properties
        vm.corporateNewsSettings;
        vm.news;

        // Load settings
        settingsApi.getSettings('CorporateNews').then(function (response) {
            vm.corporateNewsSettings = response;

            // Init app
            initialize();
        });
        

        // Public methods
        vm.sendPushNotification = sendPushNotification;

        // Private methods
        function initialize() {
            // Check if settings are available
            if (Object.keys(vm.corporateNewsSettings).length !== 0 && vm.corporateNewsSettings.constructor === Object) {
                // Load latest corporate news
                getWizdomCorporateNews(null, null, null);
            }
        }

        // Retrieve Wizdom corporate news based on news settings configured in the mobile app
        function getWizdomCorporateNews() {
            var selectPropertiesUrl = "";
            if (typeof vm.corporateNewsSettings.selectProperties !== "undefined") {
                angular.forEach(vm.corporateNewsSettings.selectProperties, function (property) {
                    selectPropertiesUrl += "&selectProperties=" + property;
                });
            }

            httpApi.get("wizdom://api/wizdom/corporateNews" +
                "/news?path=" + encodeURIComponent(vm.corporateNewsSettings.path ? vm.corporateNewsSettings.path : "") +
                "&numberOfNews=" + vm.corporateNewsSettings.numberOfNews +
                "&typeNews=" + vm.corporateNewsSettings.typeNews +
                "&orderBy=" + vm.corporateNewsSettings.orderBy +
                "&ascending=" + vm.corporateNewsSettings.ascending +
                "&cachingType=" + vm.corporateNewsSettings.cachingType +
                "&resultSource=" + vm.corporateNewsSettings.resultSource +
                "&languageFilter=" + encodeURIComponent(vm.corporateNewsSettings.languageFilterUseDynamic ? vm.corporateNewsSettings.languageFilterDynamic : vm.corporateNewsSettings.languageFilter.map(e => e.label).join(';')) +
                "&departmentFilter=" + encodeURIComponent(vm.corporateNewsSettings.departmentFilterUseDynamic ? vm.corporateNewsSettings.departmentFilterDynamic : vm.corporateNewsSettings.departmentFilter.map(e => e.label).join(';')) +
                "&locationFilter=" + encodeURIComponent(vm.corporateNewsSettings.locationFilterUseDynamic ? vm.corporateNewsSettings.locationFilterDynamic : vm.corporateNewsSettings.locationFilter.map(e => e.label).join(';')) +
                "&languageFilterUseDynamic=" + encodeURIComponent(vm.corporateNewsSettings.languageFilterUseDynamic) +
                "&departmentFilterUseDynamic=" + encodeURIComponent(vm.corporateNewsSettings.departmentFilterUseDynamic) +
                "&locationFilterUseDynamic=" + encodeURIComponent(vm.corporateNewsSettings.locationFilterUseDynamic) +
                "&includeModernNews=" + encodeURIComponent(vm.corporateNewsSettings.includeModernNews) +
                "&modernPath=" + encodeURIComponent(vm.corporateNewsSettings.pathModern ? vm.corporateNewsSettings.pathModern : "") +// + vm.corporateNewsSettings.pathModern + //
                "&includeClassicNews=" + encodeURIComponent(vm.corporateNewsSettings.includeClassicNews) +
                selectPropertiesUrl).then(function (response) {
                    vm.news = response;
                });
        }

        function sendPushNotification(itemUrl) {
            var confirm = $window.confirm(`Are you sure you want to push this message? Remember, there is no security trimming and this will impact every user with the mobile app installed and notifications enabled.`);
            if (confirm) {
                httpApi.post(`wizdom://api/wizdom/corporateNews/news/SendPush`, itemUrl).then(function (response) {
                    console.log(`Corporate news push notification send:` + response);
                });
            }
        }
    }

})();