﻿(function () {
    angular.module('WizdomMobileModule').controller('ModalNewItemController', function ($scope, $modalInstance, tier, settingsApi) {
        var vm = this;
        vm.itemOptions = ["Link", "Header"];
        vm.newItem = {
            "guid": guid(),            
            "tier": tier,
            "nextTierItems": [],
            "type": "Link",
            "iconClass": "ms-Icon ms-Icon--TriangleSolidRight12",
            "toggleOpen": false
        };

        vm.ok = function () {
            if(vm.newItem.item)
                $modalInstance.close(vm.newItem);
        };

        vm.cancel = function () {
            $modalInstance.dismiss('cancel');
        };

        //Helper functions
        function guid() {
            function s4() {
                return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
            }
            return s4() + s4() + s4() + s4() + '-' + s4() + s4() + s4() + '-' + s4() + '-' + s4() + s4() + s4() +
                s4() + '-' + s4() + s4();
        }
    });
})();
