﻿(function () {
    angular.module('WizdomMobileModule').factory('newsService', newsService);
    newsService.$inject = ['$window', '$http', '$q', 'settingsApi', 'contextInfo'];

    function newsService($window, $http, $q, settingsApi, contextInfo) {

        var baseUrl = contextInfo.spWebUrl;

        //Get a specific corporate news
        function getSpecific(guid) {
            var query = 'UniqueId:' + guid + '*'; //guid for specific news
            var properties = 'UniqueId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,VideoUrl,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL';
            var trimDuplicates = 'false';
            var startRow = 0;
            var rowLimit = 10;
            var sortList = 'LastModifiedTime:descending';
            return $http({
                method: 'GET',
                url: baseUrl + '/_api/search/query?Querytext=%27' + encodeURIComponent(query) + '*%27&selectproperties=%27' + properties + '%27&trimduplicates=%27' + trimDuplicates + ' %27&rowlimit=%27' + rowLimit + ' %27&startrow=%27' + startRow + ' %27&sortlist=%27' + sortList + ' %27',
                cache: true
            }).then(function (response) {
                // Mapping each table rows and foreach cell add variabel to object
                return response.data.PrimaryQueryResult.RelevantResults.Table.Rows.map(obj => { obj.Cells.forEach(p => obj[p.Key] = p.Value); delete obj.Cells; return obj });
            });
        }

        // Get latest corporate news
        function getLatest(rowLimit, startRow, path) {
            var query = 'ContentTypeId:0x010100C568DB52D9D0A14D9B2FDCC96666E9F2007948130EC3DB064584E219954237AF3900E1A7B5EB4F6D4536ABA24236F66055A100170370F5340444D1B84CA664EC7FB117*'; // Wizdom Newspage ContentType
            if (path) {
                query += ' path:' + path + '*';
            }
            var properties = 'UniqueId,ListID,ListItemId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,owstaxIdW365RelatedTopic,VideoUrl,ContentTypeId,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL';
            var trimDuplicates = 'false';
            var sortList = 'LastModifiedTime:descending';
            return $http({
                method: 'GET',
                url: baseUrl + '/_api/search/query?Querytext=%27' + encodeURIComponent(query) + '*%27&selectproperties=%27' + properties + '%27&trimduplicates=%27' + trimDuplicates + '%27&rowlimit=%27' + rowLimit + '%27&startrow=%27' + startRow + '%27&sortlist=%27' + sortList + '%27',
                cache: true
            }).then(function (response) {
                // Mapping each table rows and foreach cell add variabel to object
                return response.data.PrimaryQueryResult.RelevantResults.Table.Rows.map(obj => { obj.Cells.forEach(p => obj[p.Key] = p.Value); delete obj.Cells; return obj });
            });
        }

        // Get trending news based on viewsrecent
        function getTrending(rowLimit, startRow, path) {
            var query = 'ContentTypeId:0x010100C568DB52D9D0A14D9B2FDCC96666E9F2007948130EC3DB064584E219954237AF3900E1A7B5EB4F6D4536ABA24236F66055A100170370F5340444D1B84CA664EC7FB117*'; 
            if (path) {
                query += ' path:' + path + '*';
            }
            var properties = 'UniqueId,ListID,ListItemId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,owstaxIdW365RelatedTopic,VideoUrl,ContentTypeId,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL,ViewsRecent,ViewsRecentUniqueUsers,ViewsLifetime,ViewsLifeTimeUniqueUsers';
            var trimDuplicates = 'false';
            var sortList = 'ViewsRecent:descending';
            return $http({
                method: 'GET',
                url: baseUrl + '/_api/search/query?Querytext=%27' + encodeURIComponent(query) + '*%27&selectproperties=%27' + properties + '%27&trimduplicates=%27' + trimDuplicates + '%27&rowlimit=%27' + rowLimit + '%27&startrow=%27' + startRow + '%27&sortlist=%27' + sortList + '%27',
                cache: true
            }).then(function (response) {
                // Mapping each table rows and foreach cell add variabel to object
                return response.data.PrimaryQueryResult.RelevantResults.Table.Rows.map(obj => { obj.Cells.forEach(p => obj[p.Key] = p.Value); delete obj.Cells; return obj });
            });
        }

        var service = {
            getLatest: getLatest,
            getTrending: getTrending,
            getSpecific: getSpecific
        };

        return service;
    }
})();