﻿//// Api Service to post through Wizdom
(function () {
    angular.module("WizdomMobileModule").factory("wcmStarterHttpApi", httpApi);

    httpApi.$inject = ["$q", "contextInfo", "wcmStarterModuleConfiguration"];

    function httpApi($q, contextInfo, moduleConfiguration) {
        var appUrl = moduleConfiguration.appUrl;
        var service = this;
        service.get = getFn;
        service.post = function (url, data) { return makeRequest("POST", url, data); };
        service.put = putFn;
        service.delete = deleteFn;
        service.getCached = getFnAppCached;
        service.resetCache = function (url) {
            promises[url] = null;
        }

        var promises = [];
        function getFn(url) {
            return makeRequest("GET", url, null);
        }
        function getFnAppCached(url) {
            if (promises[url] == null) {
                promises[url] = getFn(url);
            }
            return promises[url];
        }
        function putFn(url, data) {
            return makeRequest("PUT", url, data);
        }
        function deleteFn(url) {
            return makeRequest("DELETE", url, null);
        }

        var requestQueue = [];
        var requestIndex = 0;
        function makeRequest(method, url, data) {
            var deferred = $q.defer(), pos = url.indexOf('://'), wizPrefix = 'wizdom://', wizPos = url.indexOf(wizPrefix);
            if (wizPos == 0) {
                url = url.replace(wizPrefix, '/');
            } else if (pos < 0) {
                url = appUrl + url;
            }
            var queryStart = url.indexOf("?") > 0 ? "&" : "?", urlParts = [];
            urlParts.push(url);
            urlParts.push(queryStart);
            if (url.indexOf("SPHostUrl=") < 0) {
                urlParts.push("SPHostUrl=" + window["encodeURIComponent"](contextInfo.spWebUrl || contextInfo.spHostUrl));
            }
            if (url.indexOf("SPLocale=") < 0) {
                urlParts.push("&SPLocale=" + window["encodeURIComponent"](contextInfo.locale));
            }
            url = urlParts.join("");

            requestQueue[requestIndex] = deferred;
            window.parent.postMessage(JSON.stringify({
                command: "ExternalRequest",
                method: method,
                url: url,
                data: data,
                context: appUrl+requestIndex++
            }), "*");
            return deferred.promise;
        }
        function postMessageHandler(e) {
            try {
                var message = JSON.parse(e.data);
                if (!message.command)
                    return;
                if (message.command === "ExternalRequestSuccess" && ("" + message.context).indexOf(appUrl) >= 0) {
                    requestQueue[message.context.replace(appUrl, "")].resolve(message.result);
                }
                if (message.command === "ExternalRequestError" && ("" + message.context).indexOf(appUrl) >= 0) {
                    requestQueue[message.context.replace(appUrl, "")].reject(message.result);
                }
            }
            catch (e) {
                if (("" + message.context).indexOf(appUrl) >= 0)
                    requestQueue[message.context.replace(appUrl, "")].reject(message.result)
            }
        }
        
        function init() {
            console.log("init");
            if (typeof window.addEventListener != 'undefined')
                window.addEventListener('message', postMessageHandler, false);
            else if (typeof window["attachEvent"] != 'undefined')
                window["attachEvent"]('onmessage', postMessageHandler);
        }
        init();
        return service;
    }
})();