﻿(function () {
    angular.module('WizdomMobileModule').factory('contentpageService', contentpageService);
    contentpageService.$inject = ['$q', '$http', '$window', '$state', 'settingsApi'];

    function contentpageService($q, $http, $window, $state, settingsApi) {
        
        //Get Content page matching guid from param
        function getContentPage(guid) {

            var contentpage;
            var deferred = $q.defer();
            settingsApi.getSettings('ContentPages').then(function (response) {
                contentpage = response.contentPagesCollection.find(x => x.guid === guid);
                if (contentpage !== undefined) {
                    deferred.resolve(contentpage);
                } else {
                    deferred.resolve({
                        title: "No matching Content Page"
                    });
                }
               
            });

            return deferred.promise.then(function (contentpage) {
                return contentpage;
            });
            
                      
        }

        var service = {
            getContentPage: getContentPage
        };

        return service;
    }
})();