﻿(function () {
    angular.module('WizdomMobileModule').directive('dotdotdot', dotdotdotDirective);

    dotdotdotDirective.$inject = [];
    function dotdotdotDirective() {
        return {
            restrict: 'A',
            scope: {
                ellipsis: '=', // The text to add as ellipsis.
                height: '=', // The (max-)height for the wrapper: null: measure the CSS (max-)height ones; a number: sets a specific height in pixels; "watch": re-measures the CSS (max-)height in the "watch". 
                truncate: '=', // How to truncate the text: By "node", "word" or "letter".
                watch: '=' //  Whether to update the ellipsis: true: Monitors the wrapper width and height; "window": Monitors the window width and height. 
            },
            link: function (scope, element, attributes) {
                element.dotdotdot({ ellipsis: scope.ellipsis, height: scope.height, truncate: scope.truncate, watch: scope.watch });
            }
        };
    }
})();