﻿(function () {
    angular.module('WizdomMobileModule').controller('mobileCommentsPanelController', mobileCommentsPanelController);
    mobileCommentsPanelController.$inject = ['$scope', '$window', '$modal', 'wcmStarterHttpApi', 'webApiProxy', 'contextInfo', 'noticeboardApi'];

    function mobileCommentsPanelController($scope, $window, $modal, httpApi, webApiProxy, contextInfo, noticeboardApi) {

        // Properties
        $scope.newCommentText;
        $scope.notifyPrincipals = [];

        // Public methods
        $scope.createComment = createComment;
        $scope.replyComment = replyComment;
        $scope.showCommentUpdate = showCommentUpdate;
        $scope.openReplyModel = openReplyModel;
        $scope.cancelCommentUpdate = cancelCommentUpdate;
        $scope.updateComment = updateComment;
        $scope.deleteComment = deleteComment;
        $scope.likeComment = likeComment;
        $scope.keypress = keypress;
        $scope.selectUser = selectUser;
        $scope.searchForPrincipal = searchForPrincipal;
        $scope.loadComments = loadComments;
        $scope.targetTotalComments = 0;
        $scope.loadingMore = false;

        var commentsLoaded = false;
        // Private methods
        function initialize() {
            
            if (typeof $scope.item !== 'undefined' && $scope.item !== null) {
                // Load full comments
                if (typeof $scope.item.comments !== 'undefined' && $scope.item.comments !== null) {
                    var emptyComments = $scope.item.comments.filter(c => c.author === null);
                    var ids = emptyComments.map(c => {
                        return c.commentID;
                    });



                    if (ids.length > 0) {
                        webApiProxy.social.getFullComments(ids.join()).then(function (response) {

                            for (var i = 0; i < response.length; i++) {
                                var index = $scope.item.comments.findIndex(c => c.commentID === response[i].commentID);
                                if (index !== -1) {
                                    $scope.item.comments[index] = response[i];
                                }
                            }

                        });
                    }
                    if (!commentsLoaded) {
                        commentsLoaded = true;
                         webApiProxy.social.getCommentsTree($scope.item.id, $scope.item.id, 'item', 0, 2).then(function (response) {
                             $scope.targetTotalComments = response.targetTotalComments;
                            $scope.item.comments = [];
                            console.log("getCommentsTree*************(1)", response);
                            for (var i = response.comments.length - 1; i >= 0; i--) {
                                response.comments[i].comments = response.comments[i].comments.reverse();
                            }
                            $scope.item.comments = response.comments.reverse();
                        });
                    }
                       
                    

                    // Check if any comment is liked by currentuser
                    for (var i = 0; i < $scope.item.comments.length; i++) {
                        var isLiked = $scope.item.comments[i].likes.some(function (element) {
                            return element.principal.loginName.toLowerCase() === contextInfo.userLoginName.toLowerCase();
                        });

                        $scope.item.comments[i].likedByCurrentUser = isLiked;
                    }
                }
            }

           
        }
        initialize();

        function createComment() {

            if (!$scope.newCommentText) return;

            var commentDto = {
                "commentID": null,
                "targetID": $scope.itemId.toString(),
                "targetType": $scope.itemType,
                "content": $scope.newCommentText,
                "picture": null,
                "preview": true,
                "previewMetadata": null,
                "datePosted": new Date(),
                "dateModified": null
            };

            webApiProxy.social.saveComment(commentDto).then(function (response) {

                if (response !== null) {
                    // Add comment to UI
                    $scope.item.comments.push(response);

                    // Check for mentions
                    if ($scope.notifyPrincipals.length > 0) {
                        var mentioList = [];
                        for (var i = 0; i < $scope.notifyPrincipals.length; i++) {
                            var mentioDto = {
                                "receiver": $scope.notifyPrincipals[i],
                                "targetID": $scope.itemId,
                                "targetType": $scope.itemType
                            };
                            mentioList.push(mentioDto);
                        }
                        if (mentioList.length > 0) {
                            webApiProxy.social.addMentio(mentioList);
                        }
                    }

                    // Clear variables
                    $scope.newCommentText = '';
                    $scope.notifyPrincipals = [];
                }

            });
        }

        
        function replyComment(comment) {

            if (!comment.replyText || comment.replyText === "") return;

            let commentDto = {
                "commentID": null,
                "targetID": comment.commentID,
                "targetType": 2,
                "content": comment.replyText,
                "datePosted": new Date(),
            };
           // console.log("Resposta comentario", commentDto);

            webApiProxy.social.saveComment(commentDto).then(function (response) {

                if (response !== null) {
            //        // Add comment to UI
                    if (!comment.comments)
                        comment.comments = [];
                    comment.comments.push(response);

            //        // Check for mentions
                    if ($scope.notifyPrincipals.length > 0) {
                        var mentioList = [];
                        for (var i = 0; i < $scope.notifyPrincipals.length; i++) {
                            var mentioDto = {
                                "receiver": $scope.notifyPrincipals[i],
                                "targetID": $scope.itemId,
                                "targetType": $scope.itemType
                           };
                            mentioList.push(mentioDto);
                       }
                        if (mentioList.length > 0) {
                            webApiProxy.social.addMentio(mentioList);
                        }
                    }

                    // Clear variables
                    comment.replyText = '';
                    $scope.notifyPrincipals = [];
                    comment.replyMode = false;
                }

           });
        }
        function showCommentUpdate(comment) {
            comment.editMode = true;
            comment.editedContent = comment.content;
        }

        function cancelCommentUpdate(comment) {
            comment.editMode = false;
            comment.editedContent = '';
        }

        function openReplyModel(comment) {
            comment.replyText = "";
            comment.replyMode = !comment.replyMode;
            let index = $scope.item.comments.findIndex(c => c.replyMode && c.commentID !== comment.commentID);
            if (index !== -1) {
                $scope.item.comments[index].replyMode = false;
            }

        }

        function updateComment(comment) {
            var commentDto = {
                "commentID": comment.commentID,
                "targetID": $scope.itemId.toString(),
                "targetType": $scope.itemType,
                "content": comment.editedContent,
                "picture": null,
                "preview": true,
                "previewMetadata": null,
                "datePosted": new Date(),
                "dateModified": new Date(),
                "status": 1
            };

            webApiProxy.social.saveComment(commentDto).then(function (response) {
                // Update UI
                var index = $scope.item.comments.findIndex(c => c.commentID === comment.commentID);
                $scope.item.comments[index] = response;

                // Check for mentions
                if ($scope.notifyPrincipals.length > 0) {
                    var mentioList = [];
                    for (var i = 0; i < $scope.notifyPrincipals.length; i++) {
                        var mentioDto = {
                            "receiver": $scope.notifyPrincipals[i],
                            "targetID": $scope.itemId,
                            "targetType": $scope.itemType
                        };
                        mentioList.push(mentioDto);
                    }
                    if (mentioList.length > 0) {
                        webApiProxy.social.addMentio(mentioList);
                    }
                }

                // Clear variables
                $scope.editCommentText = '';
                $scope.notifyPrincipals = [];
            });

            

        }

        function deleteComment(id) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App/Directives/CommentsPanel/CommentsPanelDeleteDialog.html',
                controller: 'commentsPanelDeleteController',
                windowClass: 'wm-Dialog-Base-Wrapper',
                resolve: {
                    id: function () { return id; }
                }
            }).result.then(function (data) {
                if (data.confirmDelete) {
                    webApiProxy.social.deleteComment(id).then(function (response) {
                        var index = $scope.item.comments.findIndex(c => c.commentID === id);
                        $scope.item.comments[index].dateModified = new Date();
                        $scope.item.comments[index].status = 2; // deleted?
                    });
                }
            });
        }

        function likeComment(comment) {
            var likeDto = {
                'principal': { loginName: contextInfo.userLoginName, displayName: contextInfo.displayName },
                'targetID': comment.commentID,
                'targetType': 2 // 1: item, 2: comment , 3: corporateNews , 4: manualPage, 5: contentPage
            }

            webApiProxy.social.likeItem(likeDto)
                .then(results => {
                    if (!results)
                        return;

                    
                    if (!isLikedByCurrentUser(comment)) {
                        comment.likes.push(likeDto);
                        comment.isLiked = true;
                    }
                    else {
                        var index = comment.likes.findIndex(like => like.principal.loginName.toLowerCase() === contextInfo.userLoginName.toLowerCase());
                        if (index !== -1) {
                            comment.likes.splice(index, 1);
                        }
                        comment.isLiked = false;
                    }
                });
        }

        function isLikedByCurrentUser(comment) {
            return comment.likes.some(like => like.principal.loginName.toLowerCase() === contextInfo.userLoginName.toLowerCase());
        }

        function keypress($event) {
            if ($event.keyCode === 10) {
                postComment();
            }
        };

        function selectUser(item) {
            if (!_.contains($scope.notifyPrincipals, item))
                $scope.notifyPrincipals.push(item);
            return convertNameToMentio(item.displayName);
        }

        function searchForPrincipal(searchTerm, allowWizdomGroups) {
            if (!searchTerm || searchTerm.length < 2) {
                $scope.searchPrincipals = [];
                return;
            }
            allowWizdomGroups = allowWizdomGroups || false;
            return noticeboardApi.principals.searchForPrincipalAuthors(searchTerm, allowWizdomGroups)
                .then(function (results) {
                    $scope.searchPrincipals = results;
                });
        };

        function convertNameToMentio(name) {
            return "@" + name.replace(/ /g, '');
        }

        function loadComments(comment = null) {

            if (comment && !comment.comments) comment.comments = [];

            var itemId = comment !== null ? comment.commentID : $scope.item.id;
            var targetId = comment !== null ? comment.commentID : itemId;
            var targetType = comment !== null ? "Comment" : "item";
            var targetLastCommentId = comment !== null ? (comment.comments.length > 0 ? comment.comments[0].commentID : 0) : $scope.item.comments[0].commentID;
            var allowedlevel = 2;

            if (comment !== null)
                comment.loadingMoreReply = true;
            else
                $scope.loadingMore = true;

            webApiProxy.social.getCommentsTree(itemId, targetId, targetType, targetLastCommentId, allowedlevel).then(function (response) {
                response.comments.sort((a, b) => a.commentID - b.commentID);
                if (comment !== null) {
                    var index = $scope.item.comments.findIndex(c => c.commentID === comment.commentID);
                    for (var i = response.comments.length - 1; i > -1; i--) {
                        if ($scope.item.comments[index].comments.findIndex(c => c.commentID === response.comments[i].commentID) > -1) continue; //not loading repetead replies
                        $scope.item.comments[index].comments.unshift(response.comments[i]);
                    }

                    comment.loadingMoreReply = false;
                }
                else {
                    for (var i = response.comments.length -1; i >-1 ; i--) {

                        if ($scope.item.comments.findIndex(c => c.commentID === response.comments[i].commentID) > -1) continue; //not loading repetead comments

                        response.comments[i].comments = response.comments[i].comments.reverse();
                        $scope.item.comments.unshift(response.comments[i]);
                    }
                    $scope.loadingMore = false;
                }
            });
        }

        // Watchers
        $scope.$watch('item', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                initialize();
            }
        }, true);

    }
})();