﻿(function () {
    try {

        angular.module('WizdomMobileModule').config(config);
        config.$inject = ["$urlRouterProvider", "$stateProvider"];

        function config($urlRouterProvider, $stateProvider) {

            // For anyDin placering unmatched url, send to /home
            $urlRouterProvider.otherwise("/");

            // Home
            $stateProvider.state('home', {
                url: '/',
                resolve: {
                    focusArticleSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('FocusArticle');
                    }],
                    exploreLinksSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('ExploreLinks');
                    }],
                    linkSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('Links');
                    }],
                    corporateNewsSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('CorporateNews');
                    }],
                    latestNewsSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('NewsLatest');
                    }],
                    trendingNewsSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('NewsTrending');
                    }],
                    noticeboardSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('NewsNoticeboard');
                    }],
                    peopleSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('People');
                    }],
                    menuSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('AppMenuBuilder');
                    }],
                    newsType: function () {
                        return 'home-latest';
                    }
                },
                views: {
                    '': {
                        templateUrl: 'WizdomMobileModule/App/Views/Home/Home.html',
                        controller: 'homeController'
                    },
                    'welcome@home': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/Welcome/WelcomeTemplate.html',
                        controller: 'welcomeController'
                    },
                    'latest@home': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/DisplayNews/DisplayNewsTemplate.html',
                        controller: 'displayNewsController'
                    },
                    'noticeboard@home': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/DisplayNoticeboard/DisplayNoticeboardTemplate.html',
                        controller: 'displayNoticeboardController'
                    },
                    'explore@home': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/ExploreLinks/ExploreLinksTemplate.html',
                        controller: 'exploreLinksController'
                    },
                    'links@home': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/Links/LinksTemplate.html',
                        controller: 'linksController'
                    },
                    'focus@home': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/FocusImage/FocusImage.html',
                        controller: 'focusImageController'
                    }
                },
                params: {
                    type: 'home-latest'
                },
                data: function ($stateParams) {
                    return $stateParams.type;
                }
            });

            $stateProvider.state('home.article', {
                url: '/:id',
                templateUrl: function ($stateParams) {
                    return 'WizdomMobileModule/App/Views/Partials/ArticleViewer/Templates/News.html';
                },
                controller: 'articleViewerController',
                params: {
                    title: '',
                    id: null,
                    item: null,
                    type: ''
                }
            }); 

            $stateProvider.state('home.contentpageviewer', {
                url: '/contentpage/:contentpageguid',
                templateUrl: 'WizdomMobileModule/App/Views/Contentpage/Contentpage.html',
                controller: 'contentpageController',
                resolve: {
                    contentpage: ['contentpageService', '$stateParams', function (contentpageService, $stateParams) {
                        return contentpageService.getContentPage($stateParams.contentpageguid);
                    }]
                },
                params: {
                    transitionDirection: ''
                }
            });

            // News
            $stateProvider.state('news', {
                //abstract to have a default view in this state. todo: store which state was last used and save in navigation.html template.
                abstract: true,
                resolve: {
                    corporateNewsSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('CorporateNews');
                    }],
                    latestNewsSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('NewsLatest');
                    }],
                    trendingNewsSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('NewsTrending');
                    }]
                },
                views: {
                    '': {
                        url: '/news',
                        templateUrl: 'WizdomMobileModule/App/Views/News/News.html',
                        controller: 'newsController'
                    },
                    'subnavigation@news': {
                        templateUrl: 'WizdomMobileModule/App/Views/News/Navigation/News_Nav.html',
                        controller: 'newsNavController'
                    }
                }
            });

            $stateProvider.state('news.type', {
                url: '/news/:type',
                templateUrl: 'WizdomMobileModule/App/Views/Partials/DisplayNews/DisplayNewsTemplate.html',
                controller: 'displayNewsController',
                data: function ($stateParams) {
                    return $stateParams.type;
                }
            });

            $stateProvider.state('news.article', {
                url: '/:id',
                templateUrl: function ($stateParams) {
                    return 'WizdomMobileModule/App/Views/Partials/ArticleViewer/Templates/News.html';
                },
                controller: 'articleViewerController',
                params: {
                    id: null,
                    item: null,
                    type: ''
                }
            });

            $stateProvider.state('noticeboard', {
                resolve: {
                    noticeboardSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('NewsNoticeboard');
                    }]
                },
                url: '/noticeboard',
                templateUrl: 'WizdomMobileModule/App/Views/Noticeboard/Noticeboard.html',
                controller: 'noticeboardController',
                params: {
                    transitionDirection: ''
                }
            });

            $stateProvider.state('noticeboard.article', {
                url: '/:id',
                templateUrl: function ($stateParams) {
                    return 'WizdomMobileModule/App/Views/Partials/ArticleViewer/Templates/Noticeboard.html';
                },
                controller: 'articleViewerController',
                params: {
                    title: '',
                    id: null,
                    item: null,
                    type: ''
                }
            });

            // People
            $stateProvider.state('people', {
                url: "/people",
                templateUrl: 'WizdomMobileModule/App/Views/People/People.html',
                controller: 'peopleController',
                params: {
                    transitionDirection: ''
                },
                resolve: {
                    peopleSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('People');
                    }],
                }
            });

            $stateProvider.state('people.detail', {
                url: '/:accountName',
                controller: 'peopleModalController',
                params: {
                    user: null
                }
            });

            // Push
            $stateProvider.state('push', {
                url: '/push',
                views: {
                    '': {
                        templateUrl: 'WizdomMobileModule/App/Views/Push/Push.html',
                        controller: 'pushController'
                    },
                    'default@push': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/PushDefault/PushDefaultTemplate.html',
                        controller: 'pushDefaultController'
                    },
                    'advanced@push': {
                        templateUrl: 'WizdomMobileModule/App/Views/Partials/PushAdvanced/PushAdvancedTemplate.html',
                        controller: 'pushAdvancedController'
                    },
                }
            });
            $stateProvider.state('push.advanced', {
                url: '/:channel',
                templateUrl: 'WizdomMobileModule/App/Views/Partials/PushAdvanced/AdvancedItemsTemplate.html',
                controller: 'advancedItemsController',
                params: {
                    channelSetId: null,
                    channel: null,
                    channels: null,
                    events: null,
                    userPushEvents: null
                }
            });

            // Menu
            $stateProvider.state('menu', {
                abstract: true,
                resolve: {
                    items: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('AppMenuBuilder');
                    }]
                },
                views: {
                    '': {
                        url: '/menu',
                        templateUrl: 'WizdomMobileModule/App/Views/Menu/Menu.html',
                        controller: 'menuController'
                    },
                    'navigation@menu': {
                        templateUrl: 'WizdomMobileModule/App/Views/Menu/Templates/Menu_Navigation.html'
                    }
                },
                params: {
                    transitionDirection: ''
                }
            });

            $stateProvider.state('menu.sub', {
                url: '/menu/:sub',
                templateUrl: 'WizdomMobileModule/App/Views/Menu/Templates/Menu_Sub.html',
                controller: 'subMenuController',
                params: {
                    sub: null,
                    subItem: null
                },
                resolve: {
                    items: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('AppMenuBuilder');
                    }]
                }
            });

            $stateProvider.state('menu.contentpageviewer', {
                url: '/contentpage/:contentpageguid',
                templateUrl: 'WizdomMobileModule/App/Views/Contentpage/Contentpage.html',
                controller: 'contentpageController',
                resolve: {
                    contentpage: ['contentpageService', '$stateParams', function (contentpageService, $stateParams) {
                        return contentpageService.getContentPage($stateParams.contentpageguid);
                    }]
                },
                params: {
                    transitionDirection: ''
                }
            });

            // Custom lightning pages
            $stateProvider.state('custompages', {
                resolve: {
                    pageSettings: ['settingsApi', function (settingsApi) {
                        return settingsApi.getSettings('customPages');
                    }]
                },
                url: '/custompages/:custompage',
                templateProvider: function ($templateRequest, $stateParams, pageSettings) {
                    var page = $stateParams.custompage

                    var templateLocation = 'WizdomMobileModule/App/Views/404.html'
                    $stateParams.doesExists = false;

                    for (i = 0; i < pageSettings.customPages.length; i++) {
                        if (pageSettings.customPages[i].pageUrl.indexOf(page) != -1) {
                            templateLocation = window._spPageContextInfo.webAbsoluteUrl + '/' + page + '.html';
                            $stateParams.doesExists = true;
                        }
                    }

                    return $templateRequest(templateLocation);

                },
                controllerProvider: function ($stateParams) {
                    var page = $stateParams.custompage;

                    if ($stateParams.doesExists) {
                        var ctrlName = page + 'Controller';
                        return ctrlName;
                    }
                }
            });
        }
    }
    catch (ex) {
        console.log(ex);
    }

})();