﻿(function () {
    angular.module('WizdomMobileModule').factory('userProfile', userProfileService);
    userProfileService.$inject = ['$window', '$http', '$timeout', 'contextInfo', 'wcmStarterHttpApi'];

    function userProfileService($window, $http, $timeout, contextInfo, httpApi) {

        var baseUrl = contextInfo.spHostUrl;

        // Get current user profile properties
        function getMyProperties() {
            httpApi.get('/api/userprofile/getmyproperties').then(function (response) {
                return response;
            });
        }

        // Get trending news based on viewsrecent
        function getTrending(rowLimit, startRow) {
            var query = 'ContentTypeId:0x010100C568DB52D9D0A14D9B2FDCC96666E9F2007948130EC3DB064584E219954237AF3900E1A7B5EB4F6D4536ABA24236F66055A100170370F5340444D1B84CA664EC7FB117*';
            var properties = 'UniqueId,ListID,ListItemId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,owstaxIdW365RelatedTopic,VideoUrl,ContentTypeId,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL,ViewsRecent,ViewsRecentUniqueUsers,ViewsLifetime,ViewsLifeTimeUniqueUsers';
            var trimDuplicates = 'false';
            var sortList = 'ViewsRecent:descending';
            return $http({
                method: 'GET',
                url: baseUrl + '/_api/search/query?Querytext=%27' + encodeURIComponent(query) + '*%27&selectproperties=%27' + properties + '%27&trimduplicates=%27' + trimDuplicates + '%27&rowlimit=%27' + rowLimit + '%27&startrow=%27' + startRow + '%27&sortlist=%27' + sortList + '%27',
                cache: true
            }).then(function (response) {
                // Mapping each table rows and foreach cell add variabel to object
                return response.data.PrimaryQueryResult.RelevantResults.Table.Rows.map(obj => { obj.Cells.forEach(p => obj[p.Key] = p.Value); delete obj.Cells; return obj });
            });
        }

        var service = {
            getLatest: getLatest,
            getTrending: getTrending
        };

        return service;
    }
})();