﻿(function () {
    angular.module("WizdomMobileModule")
        .factory("sessionStorageService", sessionStorageService);

    sessionStorageService.$inject = ["$window", "$document"];
    function sessionStorageService($window, $document) {
        return {
            setItem: function (key, value) {
                if (angular.isUndefined(value))
                    value = null;
                window.sessionStorage.setItem(getKey(key), value);
            },
            removeItem: function (key) {
                window.sessionStorage.removeItem(getKey(key));
            },
            getItem: function (key) {
                return window.sessionStorage.getItem(getKey(key));
            }
        };
    };

    // helper functions
    function getKey(key) {
        if (key.indexOf("wiz") < 0)
            return "wiz" + key;
        return key;
    };
})();
