﻿(function () {
    angular.module("WizdomMobileModule").factory("contextInfo", contextInfo);

    contextInfo.$inject = ["mobile"];
    function contextInfo(mobile) {
        var listContext = [];

        if (window["ctx"]) {
            var i = window["ctx"].ctxId;

            while (window["ctx" + i]) {
                listContext.push({ title: window["ctx" + i].ListTitle, dirUrl: window["ctx" + i].listUrlDir });
                i++;
            }

            if (listContext.length == 1) {
                listContext = listContext[0];
            }
        }

        var qsParam = getQueryParameters();
        var lang = (window["_spPageContextInfo"] ? window["_spPageContextInfo"].currentUICultureName :
            qsParam.SPLanguage ? decodeURIComponent(qsParam.SPLanguage) : "en-us").toLowerCase();  // defaults to en-us 

        return {
            pageIsInEditMode: window["PageState"] ? window["PageState"].ViewModeIsEdit == "1" : false,
            userId: window["_spPageContextInfo"] ? window["_spPageContextInfo"].userId : null,
            userLoginName: window["_spPageContextInfo"] ? window["_spPageContextInfo"].userLoginName : null,
            currentPage: window["_spPageContextInfo"] ? window["_spPageContextInfo"].serverRequestPath : null,
            pageListId: window["_spPageContextInfo"] ? window["_spPageContextInfo"].pageListId : null,
            pageItemId: window["_spPageContextInfo"] ? window["_spPageContextInfo"].pageItemId : null,
            listContext: window["ctx"] ? listContext : null,
            webServerRelativeUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].webServerRelativeUrl : null,
            siteServerRelativeUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteServerRelativeUrl : null,
            siteAbsoluteUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteAbsoluteUrl : null,
            spHostUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteAbsoluteUrl : window["decodeURIComponent"](qsParam.SPHostUrl),
            spWebUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].webAbsoluteUrl : qsParam.SPWebUrl,
            appUrl: (window["Wizdom365AppUrl"]) ? window["Wizdom365AppUrl"] : window.location.protocol + '//' + window.location.host,
            clientId: window["Wizdom365ClientID"],
            language: lang, // defaults to en-us    
            locale: qsParam.SPLocale ? decodeURIComponent(qsParam.SPLocale) : lang,  //default to language  
            productNumber: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteClientTag.split("$")[2] : qsParam.SPProductNumber,
            requestPath: window["_spPageContextInfo"] ? window["_spPageContextInfo"].serverRequestPath : null,
            isSettingsPage: location.href ? ((location.href.indexOf("_layouts/15/") > -1) && (location.href.indexOf("#") < location.href.lastIndexOf("_layouts/15/"))) : false, //Check if "layouts/15" is in url and also check if "#" is before ".aspx" (to support minimal download strategy)
            isDialogPage: location.href ? (location.href.indexOf("IsDlg=1") > -1) : false,
            isMobile: mobile.detectmob() && mobile.getCookie("WizdomMobile") !== "false" ? true : false,
            friendUrlTermId: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"].termId : null,
            friendUrlTermSetId: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"].termSetId : null,
            friendUrlTermStoreId: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"].termStoreId : null,
            pageFileVersionForDisplay: window["g_PageFileVersionForDisplay"] ? window["g_PageFileVersionForDisplay"] : null,
            friendlyUrlPageconextInfo: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"] : null,
            pageColumns: window["wizdomPageColumns"],
            wizdomEnvironmentIsOnPrem: window["WizdomEnvironmentIsOnPrem"]
        };
    };

    function getQueryParameter(name) {
        return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [, ""])[1].replace(/\+/g, '%20')) || null
    };

    function getQueryParameters() {
        return {
            SPHostUrl: getQueryParameter('SPHostUrl'),
            SPWebUrl: getQueryParameter('SPAppWebUrl'),
            SPLanguage: getQueryParameter('SPLanguage'),
            SPProductNumber: getQueryParameter('SPProductNumber'),
            SPLocale: getQueryParameter('SPLocale')
        };
    }
})();