﻿(function () {

    angular.module("WizdomMobileModule").controller("newsController", newsController);
    newsController.$inject = ["$scope", "$timeout", "$modal", "$http", "wcmStarterHttpApi", "settingsApi", "contextInfo"];
    function newsController($scope, $timeout, $modal, $http, httpApi, settingsApi, contextInfo) {
        var vm = this;

        // Properties
        vm.corporateNewsSettings;
        vm.latestNewsSettings;
        vm.trendingNewsSettings;
        vm.userProfileProperties = [];
        vm.newManagedPropertyTitle = '';
        vm.saving = false;

        // Load settings
        settingsApi.getSettings('CorporateNews').then(function (response) {
            vm.corporateNewsSettings = response;
            vm.corporateNewsSettings.ascending = response.ascending || false;
            vm.corporateNewsSettings.cachingType = response.cachingType || 0;
            vm.corporateNewsSettings.departmentFilter = response.departmentFilter || [];
            vm.corporateNewsSettings.departmentFilterDynamic = response.departmentFilterDynamic || '';
            vm.corporateNewsSettings.departmentFilterUseDynamic = response.departmentFilterUseDynamic || false;
            vm.corporateNewsSettings.includeClassicNews = response.includeClassicNews || false;
            vm.corporateNewsSettings.includeModernNews = response.includeModernNews || false;
            vm.corporateNewsSettings.languageFilter = response.languageFilter || [];
            vm.corporateNewsSettings.languageFilterDynamic = response.languageFilterDynamic || '';
            vm.corporateNewsSettings.languageFilterUseDynamic = response.languageFilterUseDynamic || false;
            vm.corporateNewsSettings.locationFilter = response.locationFilter || [];
            vm.corporateNewsSettings.locationFilterDynamic = response.locationFilterDynamic || '';
            vm.corporateNewsSettings.locationFilterUseDynamic = response.locationFilterUseDynamic || false;
            vm.corporateNewsSettings.numberOfNews = response.numberOfNews || 5;
            vm.corporateNewsSettings.orderBy = response.orderBy || 'LastModifiedTime';
            vm.corporateNewsSettings.path = response.path || '';
            vm.corporateNewsSettings.pathModern = response.pathModern || '';
            vm.corporateNewsSettings.queryMode = response.queryMode || 1;
            vm.corporateNewsSettings.resultSource = response.resultSource || '8413cd39-2156-4e00-b54d-11efd9abdb89';
            vm.corporateNewsSettings.selectProperties = ['UniqueId', 'ListID', 'ListItemId', 'Title', 'Path', 'W365EnableSocialOWSBOOL', 'W365NewsSummaryOWSHTML', 'PublishingPageContentOWSHTML', 'PublishingRollupImageOWSIMGE', 'PublishingImage', 'LastModifiedTime', 'owstaxIdW365RelatedTopic', 'VideoUrl', 'ContentTypeId', 'SPWebUrl', 'SPSiteUrl', 'W365TopNewsOWSBOOL', 'ViewsRecent', 'ViewsRecentUniqueUsers', 'ViewsLifetime', 'ViewsLifeTimeUniqueUsers', 'PromotedState', 'BannerImageUrlOWSURLH', 'PictureThumbnailURL', 'CanvasContent1OWSHTML', 'Description'];
            vm.corporateNewsSettings.typeNews = response.typeNews || 2;
        });

        settingsApi.getSettings('NewsLatest').then(function (response) {
            vm.latestNewsSettings = response;
        });

        settingsApi.getSettings('NewsTrending').then(function (response) {
            vm.trendingNewsSettings = response;
        });

        // Public methods
        vm.saveSettings = saveSettings;

        // Private methods
        function initialize() {
            // Load userprofile properties
            httpApi.get('/api/userprofile/getpropertykeys').then(function (response) {
                for (var i = 0; i < response.length; i++) {
                    vm.userProfileProperties.push({
                        title: response[i],
                        selected: false
                    });
                }
            });
        }
        initialize();

        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
        
    }
})();