﻿(function () {

    angular.module("WizdomMobileModule").controller("contentPagesAdminController", contentPagesAdminController);
    contentPagesAdminController.$inject = ["$scope", "settingsApi"];
    function contentPagesAdminController($scope, settingsApi) {
        var vm = this;

        //
        vm.fields = [];

        // Load settings
        settingsApi.getSettings('ContentPages').then(function (response) {
            vm.ContentPagesSettings = response;
        });

        // Public methods
        vm.saveSettings = saveSettings;

        // Private methods        

        vm.addField = function () {
            vm.fields.push({})
        }

        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
    }

})();