﻿// AdminApp.js
(function () {
    // Add Module to Wizdom Angular App
    angular.module("WizdomMobileModule", ['ui.bootstrap', 'ui.router', 'angularUtils.directives.dirPagination', 'ui-iconpicker', 'ui.sortable']);

    if (window["SP"]) {
        window["SP"].SOD.executeOrDelayUntilEventNotified(function () {
            if (console && console.log) { console.log("WizdomMobileModule loaded"); }
            angular.module("Wizdom365").requires.push("WizdomMobileModule");
        }, "Wizdom365Loaded");
    }

    angular.module("WizdomMobileModule").factory("wcmStarterModuleConfiguration", wcmStarterModuleConfiguration);
    function wcmStarterModuleConfiguration() {
        var service = {};

        // Get custom module app url from current script path
        service.appUrl = GetCurrentScriptHost();
        return service;
    };

    function GetCurrentScriptHost() {
        var scriptPath = '';
        try {
            //Throw an error to generate a stack trace
            throw new Error();
        }
        catch (e) {
            if (angular.isDefined(e.sourceURL)) {
                scriptPath = e.sourceURL.match(/http[s]?:\/\/.+\//)[0].replace(/\/dist\//i, "");
            } else {
                //Split the stack trace into each line
                var stackLines = e.stack.split('\n');
                var callerIndex = 0;
                //Now walk though each line until we find a path reference
                for (var i in stackLines) {
                    if (!stackLines[i].match(/http[s]?:\/\//)) continue;
                    callerIndex = Number(i);
                    break;
                }
                scriptPath = stackLines[callerIndex].match(/http[s]?:\/\/.+\//)[0].replace("/dist/", "").replace("/Dist/", "");
            }
        }
        return scriptPath;
    };


})();