﻿(function () {
    angular.module("WizdomMobileModule").controller("menuBuilderController", menuBuilderController);

    menuBuilderController.$inject = ["$scope", "administrationApi", "$timeout", "settingsApi", "$modal"];

    function menuBuilderController($scope, administrationApi, $timeout, settingsApi, $modal) {

        //initial data load
        settingsApi.getSettings("AppMenuBuilder").then(function (response) {
            $scope.menutree = response.length > 0 ? response : [];

        }, function (error) { console.log(error); });

        $scope.tempParent = {};      

        $scope.openNextTier = function (item) {
            item.open = !item.open;
        }

        $scope.saveConfig = function () {
            settingsApi.saveSettings("AppMenuBuilder",$scope.menutree).then(
                function () {
                    console.log("settings saved");
                }, function (error) {
                    console.log(error);
                }
            )
        };

        //Delete and remove functions
        $scope.deleteItem = function (guid) {
            if (confirm("Delete menu item")) {
                //Check if entry to delete is a tier 1 item
                var removeIndex = $scope.menutree.map(function (item) { return item.guid; })
                    .indexOf(guid);

                if (removeIndex !== -1) {
                    //remove tier 1 item
                    $scope.menutree.splice(removeIndex, 1);
                    var last = 0;
                    $scope.menutree
                        .sort(function (a, b) {
                            return a.order - b.order;
                        })
                        .forEach(function (l) {
                            if (l.order > (last + 1)) {
                                l.order--;
                            }

                            last++;
                        });
                } else {
                    //else loop through each tree from tier 1 items
                    for (var i = 0; i < $scope.menutree.length; i++) {
                        removeFromTree($scope.menutree[i], guid);
                    }

                }
                $scope.saveConfig();
            }
        };

        function removeFromTree(parent, childGuidToRemove) {
            //Recursive looping through three. remove the child which has the guid which we want to delete.
            parent.nextTierItems = parent.nextTierItems
                .filter(function (child) { return child.guid !== childGuidToRemove })
                .map(function (child) { return removeFromTree(child, childGuidToRemove) });
            return parent;
        }

        //Modal functions
        $scope.openNewItemModal = function (obj, tier, size) {
            $scope.tempParent = obj;

            var modalInstance = $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/MenuBuilder/Templates/MenuBuilderAddTemplate.html',
                controller: 'ModalNewItemController as ModalNewItemCtrl',
                windowClass: 'bootstrap-wrapper',
                size: size,
                resolve: {
                    tier: function () {
                        return tier;
                    },                  
                }
            });

            modalInstance.result.then(function (newItem) {
                console.log(newItem);
                addNewItem(newItem);
            }, function (error) {
                console.log(error);
                });


            function addNewItem(newItem) {
                if (newItem.tier > 1) {
                    $scope.tempParent.nextTierItems.push(newItem);
                    $scope.tempParent = {};
                    $scope.saveConfig();
                } else {
                    var order = $scope.menutree.length + 1;
                    newItem.order = order;
                    $scope.menutree.push(newItem);
                    $scope.saveConfig();
                }

            };
        };

        $scope.openEditItemModal = function (obj, size) {
            
            var modalInstance = $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/MenuBuilder/Templates/MenuBuilderEditTemplate.html',
                controller: 'ModalEditItemController as ModalEditItemCtrl',
                size: size,
                resolve: {
                    editItemObjMaster: function () {
                        return obj;
                    },
                }
            });

            modalInstance.result.then(function (data) {       
                console.log(data);
                var level2, level3;
                var found = false;

                //travel through arrays (including nested) and find item.
                for (i = 0; i < $scope.menutree.length; i++) {
                    level2 = $scope.menutree[i];
                    for (j = 0; j < level2.nextTierItems.length; j++) {
                        level3 = level2.nextTierItems[j];
                        for (h = 0; h < level3.nextTierItems.length; h++) {
                            if (level3.nextTierItems[h].guid === data.editItemObjMaster.guid) {
                                found = true;
                                angular.copy(data.editItem, level3.nextTierItems[h]);
                                break;
                            }
                        }

                        if (found)
                            break;

                        if (level2.nextTierItems[j].guid === data.editItemObjMaster.guid) {
                            found = true;
                            angular.copy(data.editItem, level2.nextTierItems[j]);
                            break;
                        }
                        
                    }

                    if (found)
                        break;

                    if ($scope.menutree[i].guid === data.editItemObjMaster.guid) {
                        found = true;
                        angular.copy(data.editItem, $scope.menutree[i]);
                        break;
                    }
                    
                }
                $scope.saveConfig();
            }, function (error) {
                console.log(error);
            });
        };


        //Order functions
        // Return array of options 1 to length of links array (5 links -> returns [1, 2, 3, 4, 5])
        $scope.getOrderOptions = function () {
            var options = [];
            for (var i = 0; i < $scope.menutree.length; i++) {
                options.push(i + 1);
            }
            return options;
        };

        // Change order value of other links depending on selection
        $scope.onOrderChange = function (link, prevStr) {
            var prev = parseInt(prevStr, 10);

            if (link.order > prev) { // If order was increased, decrease the order value of links between the previous and new position
                $scope.menutree.forEach(function (l) {
                    if (l !== link && l.order > prev && l.order <= link.order) {
                        l.order--;
                    }
                });
            } else if (link.order < prev) { // If order was decreased, increase the order value of links between the previous and new position
                $scope.menutree.forEach(function (l) {
                    if (l !== link && l.order < prev && l.order >= link.order) {
                        l.order++;
                    }
                });
            }
            $scope.saveConfig();
            
        };
    }

})();