﻿(function () {

    angular.module("WizdomMobileModule").controller("exploreLinksAddController", exploreLinksAddController);

    exploreLinksAddController.$inject = ["$scope", "$window", "$modalInstance", "editLinkObjMaster"];

    function exploreLinksAddController($scope, $window, $modalInstance, editLinkObjMaster) {
        var vm = this;

        // Properties
        vm.newLinkObj = {};
        if (editLinkObjMaster != null) vm.editLinkObj = angular.copy(editLinkObjMaster);

        // Public methods
        vm.createLink = createLink;
        vm.cancel = cancel;

        function createLink() {
            if (vm.newLinkObj.title && vm.newLinkObj.summary && vm.newLinkObj.imagePath && vm.newLinkObj.url) {
                vm.newLinkObj.visible = vm.newLinkObj.visible || false;

                $modalInstance.close(vm.newLinkObj);
            }
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();