﻿(function () {

    angular.module("WizdomMobileModule").controller("contentPagesEditController", contentPagesEditController);

    contentPagesEditController.$inject = ["$scope", "$window","guidGenerator", "$modalInstance", "editContentPageObjMaster"];

    function contentPagesEditController($scope, $window, guidGenerator, $modalInstance, editContentPageObjMaster) {
        var vm = this;

        // Properties
        vm.editedLinkItem = {};
        if (editContentPageObjMaster != null) vm.editContentPageObj = angular.copy(editContentPageObjMaster);

        // Public methods
        vm.updateContentPage = updateContentPage;
        vm.cancel = cancel;
        vm.pushLink = pushLink;
        vm.removeLink = removeLink;
        vm.editLink = editLink;
        vm.saveEditedLink = saveEditedLink;


        // Private Methods
        function saveEditedLink(index) {
            vm.editContentPageObj.links[index] = vm.editedLinkItem;
            vm.editedLinkItem = {};
        }
        function editLink(item) {
            vm.editedLinkItem = angular.copy(item);            

        }
        function pushLink(link) {
            link.guid = guidGenerator.newGuid();
            $scope.$watch(vm.editContentPageObj.links, function () {
                vm.editContentPageObj.links.push(link);
                vm.link = '';
            });
        }
        function removeLink(index) {
            $scope.$watch(vm.editContentPageObj.links, function () {
                vm.editContentPageObj.links.splice(index, 1);
            });
        }   

        function updateContentPage() {
            $modalInstance.close({
                editContentPageObjMaster: editContentPageObjMaster,
                editContentPageObj: vm.editContentPageObj
            });
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();