﻿(function () {

    angular.module("WizdomMobileModule").controller("contentPagesAdminController", contentPagesAdminController);

    contentPagesAdminController.$inject = ["$scope", "$window", "$modal", "settingsApi","contextInfo", "$timeout"];

    function contentPagesAdminController($scope, $window, $modal, settingsApi, contextInfo, $timeout) {
        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newLinkobj = {};
        vm.showEditMode = false;
        vm.spHostUrl = contextInfo.spHostUrl;

        // Load settings
        settingsApi.getSettings('ContentPages').then(function (response) {
            vm.settings = response;
            vm.settings.contentPagesCollection = vm.settings.contentPagesCollection || [];
        });

        // Public methods
        vm.addContentPage = addContentPage;
        vm.editContentPage = editContentPage;
        vm.deleteContentPage = deleteContentPage;
        vm.copyLink = copyLink;

        function addContentPage() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ContentPages/Templates/ContentPagesAddTemplate.html',
                controller: 'contentPagesAddController as contentPagesAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editContentPageObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.settings.contentPagesCollection.push(data);
                vm.saveSettings();
            });
        }

        function editContentPage(contentPage) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ContentPages/Templates/ContentPagesEditTemplate.html',
                controller: 'contentPagesEditController as contentPagesEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editContentPageObjMaster: function () { return contentPage; }
                }
            }).result.then(function (data) {
                var index = vm.settings.contentPagesCollection.indexOf(data.editContentPageObjMaster);
                angular.copy(data.editContentPageObj, vm.settings.contentPagesCollection[index]);
                vm.saveSettings();
            });
        }

        function deleteContentPage(contentPage) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.settings.contentPagesCollection.indexOf(contentPage);
                vm.settings.contentPagesCollection.splice(index, 1);
                vm.saveSettings();
            }
        }

        function copyLink($event) {                

            var currentElement = $($event.currentTarget);
            var input = currentElement.closest($(".btn-group-xs")).next();
            var popup = currentElement.prev();
            if (input.css("display") === "none") {
                activehelper(input);
                togglehelper(input);
                input.select();

                // Copy its contents
                document.execCommand("copy");

                //show "link copied" popup
                togglehelper(popup);
                var timeout = $timeout(function () {
                    togglehelper(popup);
                },1500);
                
            } else {
                togglehelper(input);
            }

            function togglehelper(e) {
                e.toggleClass("show");
            }

            function activehelper(e) {
                $(".copy-link-input").each(function (i, el) {                    
                    $(el).removeClass("show");
                });
                
            }
            
        }

        

        vm.saveSettings = function () {
            settingsApi.saveSettings('ContentPages', vm.settings).then(function (response) {
            });
        }
    }
})();
