﻿(function () {
    angular.module('WizdomMobileModule').controller('pushDefaultController', ['$scope', 'pushRegistrationsService',
        function ($scope, pushRegistrationsService) {

            // Properties
            $scope.defaults = [];

            // Public methods
            $scope.eventTypeChecked = function (eventTypeArr) {
                exists = false;
                for (var i = 0; i < eventTypeArr.length; i++) {
                    var eventItem = $scope.defaults.find(event => event.eventType === eventTypeArr[i]);
                    if (typeof eventItem !== 'undefined') {
                        if (eventItem.enabled) exists = true;
                    }
                }
                return exists;
            };

            $scope.toggleEventState = _.debounce(function (event, removeEventsArr) {

                // Check to add or update current event type
                if (event !== null) {
                    var eventItem = $scope.defaults.find(item => item.eventType === event);
                    if (typeof eventItem === 'undefined') {
                        // create eventtype and enable it
                        var eventItemObj = {
                            'eventType': event,
                            'enabled': true
                        };
                        $scope.userPushEvents.push(eventItemObj);
                    }
                    else {
                        eventItem.enabled = eventItem.enabled = !eventItem.enabled;
                    }
                }

                // Check to disable related events
                if (removeEventsArr !== null) {
                    for (var i = 0; i < removeEventsArr.length; i++) {
                        var disableItem = $scope.defaults.find(item => item.eventType === removeEventsArr[i]);
                        if (typeof disableItem !== 'undefined') {
                            disableItem.enabled = false;
                        }
                    }
                }
           
                pushRegistrationsService.setUserPushEventDefaults($scope.defaults).then(function (response) {
                });
            }, 300);

            // Private methods
            function initialize() {
                // Get default event settings
                pushRegistrationsService.getUserPushEventDefaults().then(function (response) {
                    $scope.defaults = response || [];
                });
            }
            initialize();


            //// properties
            //$scope.defaults = [];

            //// global


            ////$scope.toggleDefault = function (item, defaults) {
            ////    item.enabled = !item.enabled;
            ////    debounce(defaults);
            ////};
            //$scope.toggleSingleState = function (eventType, defaults) {

            //    for (var item = 0; item < defaults.length; item++) {

            //        if (defaults[item].eventType === eventType) {
            //            defaults[item].enabled = !defaults[item].enabled;
            //            debounce(defaults);
            //        }
            //    }

            //};

            //$scope.userPushEventExists = function (eventType, defaults) {
            //    var UserPushEventExist = false;
            //    for (var item = 0; item < defaults.length; item++) {
            //        if (eventType === defaults[item].eventType) {
            //            UserPushEventExist = defaults[item].enabled;
            //        }
            //    }
            //    return UserPushEventExist;
            //};

            //$scope.selectedTriState = function (selectedValue, defaults) {
            //    var selectedTriState = false;

            //    for (var item = 0; item < defaults.length; item++) {
            //        if (selectedValue === defaults[item].eventType) {
            //            selectedTriState = defaults[item].enabled;
            //        }
            //    }

            //    return selectedTriState;
            //};

            //$scope.selectedTriStateOff = function (all, my, defaults) {
            //    var selectedTriState = false;

            //    for (var item = 0; item < defaults.length; item++) {
            //        if (my === defaults[item].eventType || all === defaults[item].eventType) {
            //            selectedTriState = defaults[item].enabled || selectedTriState;
            //        }
            //    }

            //    return !selectedTriState;
            //};

            //$scope.toggleTriState = function (all, my, selectedValue, defaults) {
            //    for (var item = 0; item < defaults.length; item++) {

            //        //set selected to false (reset all)
            //        if (my === defaults[item].eventType || all === defaults[item].eventType) {
            //            defaults[item].enabled = defaults[item].eventType === selectedValue;
            //        }
            //    }

            //    debounce(defaults);               
            //};

            //// private

            //function getSettings() {

            //    pushRegistrationsService.getUserPushEventDefaults().then(function (response) {
            //        $scope.defaults = response || [];
            //    });
            //    pushRegistrationsService.getPushEventTypes().then(function (response) {
            //        $scope.events = response || [];
            //    });
            //}

            //// debounce the save method, so user can toggle before it saves.
            //var debounce = _.debounce(
            //    function save(defaults) {
            //        pushRegistrationsService.setUserPushEventDefaults(defaults).then(function (response) {
            //        });
            //    }, 300);

            //function init() {
            //    getSettings();
            //}
            //init();

         }]
    );
})();