﻿(function () {
    angular.module('WizdomMobileModule').controller('pushAdvancedController', ['$scope', '$stateParams', '$templateCache', 'settingsApi', 'pushRegistrationsService', 'noticeboardService',
        function ($scope, $stateParams, $templateCache, settingsApi, pushRegistrationsService, noticeboardService) {

            init();

            // properties
            $scope.userPushEvents = [];

            // public 
            $scope.toggleMainEvent = function (item) {

                var exists = $scope.userPushEvents.filter(
                    function (ele) {
                        return ele.channelID === item.id;
                    }
                );
                if (exists.length) {

                    if (confirm("You are about to delete you push events for " + item.name)) {

                        console.log("have events");
                        // loop backwards to be able to splice, because splice re-index array
                        for (var i = $scope.userPushEvents.length - 1; i >= 0; i--) {
                            if (item.id === $scope.userPushEvents[i].channelID) {
                                $scope.userPushEvents.splice(i, 1);
                            }
                        }
                        item.showEvents = !item.showEvents;
                        //$scope.containsUserPushEvents(item);

                    }
                }
                if (!exists.length) {
                    for (var j = 0; j < $scope.defaultEvents.length; j++) {
                        var userPushObject = {
                            'channelSetID': $scope.channelSetID,
                            'channelID': item.id,
                            'eventType': $scope.defaultEvents[j].eventType,
                            'enabled': $scope.defaultEvents[j].enabled
                        };
                        $scope.userPushEvents.push(userPushObject);
                    }
                }
                pushRegistrationsService.setUserPushEvents($scope.channelSetID, $scope.userPushEvents).then(function (response) {
                });
            };
            // Toggles single event type (item created, mentions) on/off
            $scope.toggleEventState = _.debounce(function (channel, event, removeEventsArr) {

                // Check to add or update current event type
                if (event != null) {
                    var eventItem = $scope.userPushEvents.find(item => item.channelSetID === $scope.channelSetID && item.channelID === channel.id && item.eventType === event);
                    if (typeof eventItem === 'undefined') {
                        // create eventtype and enable it
                        var userPushObject = {
                            'channelSetID': $scope.channelSetID,
                            'channelID': channel.id,
                            'eventType': event,
                            'enabled': true
                        };
                        $scope.userPushEvents.push(userPushObject);
                    }
                    else {
                        eventItem.enabled = eventItem.enabled = !eventItem.enabled;
                    }
                }

                // Check to disable related events
                if (removeEventsArr) {
                    for (var i = 0; i < removeEventsArr.length; i++) {
                        var disableItem = $scope.userPushEvents.find(item => item.channelSetID === $scope.channelSetID && item.channelID === channel.id && item.eventType === removeEventsArr[i]);
                        if (typeof disableItem !== 'undefined') {
                            disableItem.enabled = false;
                        }
                    }
                }

                pushRegistrationsService.setUserPushEvents($scope.channelSetID, $scope.userPushEvents).then(function (response) {
                });
            }, 300);

            $scope.advancedSettingsExists = function (channel) {
                var exists = $scope.userPushEvents.filter(function (item) {
                    if (item.channelID === channel.id) {
                        return true;
                    }
                    return false;
                });

                if (exists.length > 0) {
                    return true;
                }
                return false;
            };

            $scope.userPushEventExists = function (eventTypeArr, channel) {
                exists = false;
                for (var i = 0; i < eventTypeArr.length; i++) {
                    var eventItem = $scope.userPushEvents.find(event => event.channelID === channel.id && event.eventType === eventTypeArr[i]);
                    if (typeof eventItem !== 'undefined') {
                        if (eventItem.enabled) exists = true;
                    }
                }
                return exists;
            };


            // privates
            var flatChannels = [];

            function flattenChannels(channels) {

                for (var i = 0; i < channels.length; i++) {
                    flatChannels.push(channels[i]);

                    if (Array.isArray(channels[i].childs)) {
                        flattenChannels(channels[i].childs);
                    }
                }
                return flatChannels;
            };

            function getSettings() {

                // get the users push events(saved), based on which channelsetid there is saved in settings.
                settingsApi.getSettings('NewsNoticeboard').then(function (response) {
                    $scope.channelSetID = response.channelSetId;
                    pushRegistrationsService.getUserPushEvents($scope.channelSetID).then(function (userPushEvents) {
                        $scope.userPushEvents = userPushEvents || [];
                    });
                });

                pushRegistrationsService.getUserPushEventDefaults().then(function (response) {
                    $scope.defaultEvents = response || [];
                });

                noticeboardService.myChannelSelection().then(function (channels) {
                    $scope.flatterChannels = flattenChannels(channels);
                });

                //pushRegistrationsService.getPushEventTypes().then(function (response) {
                //    $scope.events = response || [];
                //});
            }

            var debounce = _.debounce(
                function save(channelSetID, userPushEvents) {
                    pushRegistrationsService.setUserPushEvents(channelSetID, userPushEvents).then(function (response) {
                    });
                }, 300);

            function init() {
                getSettings();
            }
        }]
    );
})();