﻿(function () {
    angular.module('WizdomMobileModule').factory('noticeboardService', noticeboardService);
    noticeboardService.$inject = ['$window', 'wcmStarterHttpApi', 'contextInfo'];

    function noticeboardService($window, httpApi, contextInfo) {

        var baseUrl = contextInfo.appUrl;

        // CHANNEL SETS
        // Get
        function getChannelSets() {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/channelsets').then(function (response) {
                return response.channelSets.results;
            });
        }

        function getChannelsetChannels(channelsetId) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/channelsets/' + channelsetId + '/channels').then(function (response) {
                return response.channels.results;
            });
        }

        //WIZDOM PRIVATE API
        function myChannelSelection() {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/views/e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4/MyChannelSelection').then(function (response) {
                return response;
            });
        }

        // PUT READ STATUS FOR A SPECIFIC NB.
        function putReadStatus(itemId, isRead) {
            return httpApi.put(contextInfo.appUrl + '/api/wizdom/noticeboard/1/items/' + itemId + '/actions/setread', isRead).then(function (response) {
            });
        }

        // ITEMS
        // Get
        function getItemById(id) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/views/e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4/items/' + id);
        }

        // VIEWS

        function getViewById(viewId) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/views/' + viewId);
        }

        function postViewById(viewId, data) {
            return httpApi.post(baseUrl + '/api/wizdom/noticeboard/1.0/views/', data);
        }

        function putViewById(viewId, data) {
            return httpApi.put(baseUrl + '/api/wizdom/noticeboard/1.0/views/' + viewId, data);
        }

        var service = {
            getChannelSets: getChannelSets,
            getChannelsetChannels: getChannelsetChannels,
            myChannelSelection: myChannelSelection,
            putReadStatus: putReadStatus,
            getItemById: getItemById,
            getViewById: getViewById,
            postViewById: postViewById,
            putViewById: putViewById
        };

        return service;
    }
})();