﻿(function () {
    angular.module("WizdomMobileModule").factory("colorShadeService", colorShadeService);
    colorShadeService.$inject = [];
    function colorShadeService() {


        // https://stackoverflow.com/questions/5560248/programmatically-lighten-or-darken-a-hex-color-or-rgb-and-blend-colors
        // Documentation for algoritm used in service.
        function shadeColor(color, percent) {
            if (typeof color != "undefined" || color != null) {
                if (color.startsWith('#')) {
                    var f = parseInt(color.slice(1), 16), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent, R = f >> 16, G = f >> 8 & 0x00FF, B = f & 0x0000FF;
                    return "#" + (0x1000000 + (Math.round((t - R) * p) + R) * 0x10000 + (Math.round((t - G) * p) + G) * 0x100 + (Math.round((t - B) * p) + B)).toString(16).slice(1);

                } else if (color.startsWith('rgb')) {
                    var f = color.split(","), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent, R = parseInt(f[0].slice(4)), G = parseInt(f[1]), B = parseInt(f[2]);
                    return "rgb(" + (Math.round((t - R) * p) + R) + "," + (Math.round((t - G) * p) + G) + "," + (Math.round((t - B) * p) + B) + ")";

                } else {
                    return color;
                }
            }

        }

        var service = {
            shadeColor: shadeColor
        };
        return service;
    }
})();