﻿(function () {
    angular.module("WizdomMobileModule").filter('extractModernPageTextAndTrustAsHtml', extractModernPageTextAndTrustAsHtmlFilter);

    extractModernPageTextAndTrustAsHtmlFilter.$inject = ['$sce'];
    function extractModernPageTextAndTrustAsHtmlFilter($sce) {
        return function (html) {
            var template = document.createElement('template');
            html = html.trim();
            template.innerHTML = html;
            var textNodes = template.content.querySelectorAll('div[data-sp-rte]');
            var trustedHtml = '';
            for (var j = 0; j < textNodes.length; j++) {
                trustedHtml += textNodes[j].innerHTML;
            }
            return $sce.trustAsHtml(trustedHtml);
        }
    }
})();