﻿(function () {
    angular.module("WizdomMobileModule").run(["settingsApi",
        function (settingsApi) {

            // Used to alternate the main navigation in app shell with custom links from backend.
            settingsApi.getSettings('navigation').then(function (response) {
                var tabs = response.tabs;
                if (tabs) {
                    for (let i = 0; i < tabs.length; i++) {
                        if (tabs[i].altUrl) {
                            try {
                                window.invokeCSharpAction(tabs[i].appShellUrlMethod + ':' + tabs[i].altUrl);
                            } catch {
                                console.log(tabs[i].appShellUrlMethod + ':' + tabs[i].altUrl);
                            }

                        } else if (tabs[i].defaultName.toLowerCase() === 'menu' && !tabs[i].altUrl) {

                            if (typeof window.invokeCSharpAction === 'function') {
                                settingsApi.getSettings('AppMenuBuilder').then(function (response) {
                                    var firstTopLevelItem = response[0];
                                    window.invokeCSharpAction('setmenuurl:' + '#!/menu/' + firstTopLevelItem.item);
                                });
                            } else {
                                console.log(tabs[i].appShellUrlMethod + ':' + tabs[i].altUrl);
                            }
                        }
                    }
                }
            });
        }
    ]);
})();