﻿[CmdletBinding(SupportsShouldProcess=$True)]
param ()

$mobileModuleName = "WizdomMobile" #The name of the custom module created in Wizdom
$wizdomMobileSiteSPO = "https://<tenant>.sharepoint.com/sites/WizdomMobile" #Absolute URL of the new mobile app site collection
#$wizdomWebsiteUrl = "https://<companyname>wizdom.azurewebsites.net" #Wizdom Azure site url (App Settings AppUrl)
$SharePointTenantAdmin = "admin@<tenant>.onmicrosoft.com" #User with administrative priveleges on the SharePoint tenant
$SharePointTenantAdminMFA = $false
$mobileSiteCollectionOwner = "admin@<tenant>.onmicrosoft.com" #User registered as site collection administrator of the mobile sitecollection
$mobileSiteCollectionTitle = "Wizdom Mobile Site" #Title of the SharePoint Site Collection
$mobileSiteCollectionLocaleId = "1033" #Regional settings of the SharePoint Site Colleciton
$wizdomSharePointAppName = "Wizdom 365" #Title of the Wizdom App installed on SharePoint
$azureSubscriptionId = "<guid>" #SubscriptionId of the Azure subscription where Wizdom is installed
$azureResourceGroupName = "Wizdom" #Azure Resource group name of the Wizdom installation
$azureMobileWebAppUrl = "https://<companyname>wizdommobile.azurewebsites.net" #Suffix appended to existing wizdomsite name to form the new mobile Azure Application Service
$azureSubscriptionAdmin = "<user>@<domain>.com"
$azureAdminMFA = $false
$mobileModuleZip = ".\SharePointOnlineInstallationSupportFiles\WizdomIntranetMobileApp_WebApp150922.zip" #Path to folder with the mobile implementation files
$outputMaxLength = 100 #Internal value - used to control width of formattet output of this script
$lightningPageTemplate = ".\SharePointOnlineInstallationSupportFiles\index.html"
$removeMode = "" # SharePointSites / AzureServices / SharePointSites_AzureServices
$enableNotifications = $true
$notificationHubNamespace = "<companyname>NotificationNamespace"
$notificationHubName = "<companyname>NotificationHub"
$notificationHubTemplate = ".\SharePointOnlineInstallationSupportFiles\template_NotificationHub.json"
$ConfirmRemove = $True

if ($outputMaxLength -lt ($wizdomMobileSiteSPO.Length + 65)) {
    $outputMaxLength = $wizdomMobileSiteSPO.Length + 65
}
Import-Module .\SharePointOnlineInstallationSupportFiles\SharePointOnlineInstallationFunctions.psm1 -Force -DisableNameChecking

    $urlBreakdown = $wizdomMobileSiteSPO.Split('/')
    $sharePointTenantAdminUrl = 'https://' + $urlBreakdown[2].split('.')[0] + '-admin.' + $urlBreakdown[2].split('.')[1] + '.' + $urlBreakdown[2].split('.')[2]

    if ($SharePointTenantAdminMFA) {
        $pnpAdminConnection = Connect-PnPOnline -ReturnConnection -Url $sharePointTenantAdminUrl -UseWebLogin

        try {Connect-SPOService -Url $sharePointTenantAdminUrl} catch {
            Write-WizdomHost -messageType ERROR -outputMaxLength $outputMaxLength -initialStringLength $output -afterOutputMessage "Cannot login. Insufficient rights? Exiting script" -WhatIf:$WhatIfPreference
            Exit
        }

    } else {
        $SPOsecurePassword = Read-Host -Prompt ("Please enter the password for " + $SharePointTenantAdmin) -AsSecureString
        $credentialsOffice365Admin = New-Object System.Management.Automation.PSCredential($SharePointTenantAdmin,$SPOsecurePassword)

        try {Connect-SPOService -Url $sharePointTenantAdminUrl -Credential $credentialsOffice365Admin} catch {
            Write-WizdomHost -messageType ERROR -outputMaxLength $outputMaxLength -initialStringLength $output -afterOutputMessage "Cannot login. Insufficient rights? Exiting script" -WhatIf:$WhatIfPreference
            Exit
        }
        $pnpAdminConnection = Connect-PnPOnline -ReturnConnection -Url $sharePointTenantAdminUrl -Credentials $credentialsOffice365Admin
    }
    
    $wizdomSharePointAppId = (Get-PnPApp -Connection $pnpAdminConnection).where({$_.Title -eq $wizdomSharePointAppName}).id.ToString()


        try {
                if ($azureAdminMFA) {
                    $output = Write-WizdomHost -messageType PROCESS -message ("Logging in to Azure as " + $AzureSubscriptionAdmin) -whatIf:$WhatIfPreference
                    $azureContext = Login-AzureRmAccount -Subscription $azureSubscriptionId -ErrorAction Stop -WhatIf:$false
                    Write-WizdomHost -messageType OK -outputMaxLength $outputMaxLength -initialStringLength $output -WhatIf:$WhatIfPreference
                } else {
                    $AzureSecurePassword = Read-Host -Prompt ("Please enter the password for " + $azureSubscriptionAdmin) -AsSecureString
                    $credentialsAzureAdmin = New-Object System.Management.Automation.PSCredential($azureSubscriptionAdmin,$AzureSecurePassword)
                    $azureContext = Login-AzureRmAccount -Subscription $azureSubscriptionId -Credential $credentialsAzureAdmin -ErrorAction Stop -WhatIf:$false
                }
            } catch {
            Write-WizdomHost -messageType ERROR -outputMaxLength $outputMaxLength -initialStringLength $output -afterOutputMessage "Cannot login. Password or username incorrect. Exiting script" -WhatIf:$WhatIfPreference
            Exit
        }

    
    
if ($SharePointTenantAdminMFA) {
    $mobileParameters = @{
        mobileModuleName = $mobileModuleName
        wizdomMobileSiteSPO = $wizdomMobileSiteSPO
        wizdomWebsiteUrl = $wizdomWebsiteUrl
        sharePointAdminUsr = $SharePointTenantAdmin
        mobileSiteCollectionOwner = $mobileSiteCollectionOwner
        mobileSiteCollectionTitle = $mobileSiteCollectionTitle
        mobileSiteCollectionLocaleId = $mobileSiteCollectionLocaleId
        wizdomSharePointAppId = $wizdomSharePointAppId
        azureResourceGroupName = $azureResourceGroupName
        azureMobileWebAppUrl = $azureMobileWebAppUrl
        mobileModuleZip = $mobileModuleZip
        outputMaxLength = $outputMaxLength
        lightningPageTemplate = $lightningPageTemplate
        installMode = "MobileSolution"
        removeMode = $removeMode
        wizdomSharePointAppName = $wizdomSharePointAppName
        enableNotifications = $enableNotifications
        notificationHubNamespace = $notificationHubNamespace
        notificationHubName = $notificationHubName
        notificationHubTemplate = $notificationHubTemplate
        ConfirmRemove = $ConfirmRemove
    }

} else {
    $mobileParameters = @{
        mobileModuleName = $mobileModuleName
        wizdomMobileSiteSPO = $wizdomMobileSiteSPO
        wizdomWebsiteUrl = $wizdomWebsiteUrl
        sharePointAdminUsr = $SharePointTenantAdmin
        sharePointAdminCredentials = $credentialsOffice365Admin
        mobileSiteCollectionOwner = $mobileSiteCollectionOwner
        mobileSiteCollectionTitle = $mobileSiteCollectionTitle
        mobileSiteCollectionLocaleId = $mobileSiteCollectionLocaleId
        wizdomSharePointAppId = $wizdomSharePointAppId
        azureResourceGroupName = $azureResourceGroupName
        azureMobileWebAppUrl = $azureMobileWebAppUrl
        mobileModuleZip = $mobileModuleZip
        outputMaxLength = $outputMaxLength
        lightningPageTemplate = $lightningPageTemplate
        installMode = "MobileSolution"
        removeMode = $removeMode
        wizdomSharePointAppName = $wizdomSharePointAppName
        enableNotifications = $enableNotifications
        notificationHubNamespace = $notificationHubNamespace
        notificationHubName = $notificationHubName
        notificationHubTemplate = $notificationHubTemplate
        ConfirmRemove = $ConfirmRemove
    }
}
Install-WizdomMobile @mobileParameters -whatIf:$WhatIfPreference -Verbose:$VerbosePreference