﻿param (
   [Parameter(Mandatory=$true, ParameterSetName='manualvalue')][string]$siteName,
   [Parameter(Mandatory=$true, ParameterSetName='manualvalue')][string]$username,
   [Parameter(Mandatory=$true, ParameterSetName='manualvalue')][string]$password,
   [Parameter(Mandatory=$true, ParameterSetName='manualvalue')][string]$deployUrl,
   [Parameter(Mandatory=$true, ParameterSetName='publishingprofile')][string]$publishingprofile,
   [Parameter(Mandatory=$false)][bool]$skipWebconfig = $false,
    [Parameter(Mandatory=$false)][switch]$OpenDeploymentInNewWindow
)

#Build variables
if ($publishingprofile) {
    $siteName = (select-xml -xpath "//publishData/publishProfile[@publishMethod = 'MSDeploy']/@msdeploySite" -Path $publishingprofile).Node.Value
    $username = (select-xml -xpath "//publishData/publishProfile[@publishMethod = 'MSDeploy']/@userName" -Path $publishingprofile).Node.Value
    $password = (select-xml -xpath "//publishData/publishProfile[@publishMethod = 'MSDeploy']/@userPWD" -Path $publishingprofile).Node.Value
}
$deployUrl = "https://" + $siteName + ".scm.azurewebsites.net/MSDeploy.axd?site=" + $siteName


write "Starting deploy script";
#cd \\wizdom365-build\builds
$path = convert-path .;
#$buildDefName = "Dev Build"
#$configuration = "Debug onprem";
#$siteName = "wizdom";
$zipFileName = "GUI.Web.zip";
$parameterFileName = "GUI.Web.SetParameters.xml";

write "path: $path";
write "siteName: $siteName";
write "zipFileName: $zipFileName";
write "parameterFileName: $parameterFileName";
write "username: $username";
write "password: $password";
write "deployUrl: $deployUrl";
write "skipWebconfig: $skipWebconfig";

# Find build Definition root
#$buildDefinitionRoot = "$path\$buildDefName";
#write "buildDefRoot: $buildDefinitionRoot";

# Find Lastest build folder
#$latestBuildFolder = Get-ChildItem $buildDefinitionRoot | ? { $_.PSIsContainer } | sort CreationTime -desc | select -f 1;
#write "latest build folder: $latestBuildFolder";

# find correct configuration
#$latestBuildConfigurationFolder = "$path\$latestBuildFolder\$configuration";
#write "latest build configuration folder: $latestBuildConfigurationFolder";

# find DeployCmdFilePath
$zipPath = "$path\wizdom365-build\$zipFileName";
$paramPath = "$path\wizdom365-build\$parameterFileName";
write "DeployCmdFilePath: $DeployCmdFilePath";
write "paramPath: $paramPath";

# Update parameter file
$x = Select-Xml -Path $paramPath -XPath "/parameters/setParameter[@name='IIS Web Application Name']";
$x.Node.value = $siteName;
$x.Node.OwnerDocument.Save($x.Path);

# Find Path to MSDeploy.exe
$MSDeployKey = 'HKLM:\SOFTWARE\Microsoft\IIS Extensions\MSDeploy\3';
if(!(Test-Path $MSDeployKey)) {
    throw "Could not find MSDeploy. Use Web Platform Installer to install the 'Web Deployment Tool' and re-run this command";
}
$InstallPath = (Get-ItemProperty $MSDeployKey).InstallPath;
if(!$InstallPath -or !(Test-Path $InstallPath)) {
    throw "Could not find MSDeploy. Use Web Platform Installer to install the 'Web Deployment Tool' and re-run this command";
}

$msdeploy = Join-Path $InstallPath "msdeploy.exe";
if(!(Test-Path $MSDeploy)) {
    throw "Could not find MSDeploy. Use Web Platform Installer to install the 'Web Deployment Tool' and re-run this command";
}
    
# specify msdeploy parameters
$arguments = [System.Collections.ArrayList]@(
	"-source:package='$zipPath'",
	"-dest:auto,computerName=""$deployUrl"",userName=""$username"",password=""$password"",authtype=""Basic"",includeAcls=""False""",
	"-verb:sync",
	"-disableLink:AppPoolExtension",
	"-disableLink:ContentExtension",
	"-disableLink:CertificateExtension",
	"-allowUntrusted",
    "-skip:Directory=""PartnerModules""",
    "-skip:Directory=""jobs""",
    #"-skip:Directory=""Logs""",
    "-skip:Directory=""FileStorage""",
	"-setParamFile:""$paramPath"""
)

if($skipWebconfig) {
    $arguments.Add("-skip:File=web\.config");
}

 #Start the msdeploy process
if ($OpenDeploymentInNewWindow.IsPresent) {
    Start-Process $msdeploy -ArgumentList $arguments -Wait;
} else {
    Start-Process $msdeploy -ArgumentList $arguments -NoNewWindow -Wait;
}
