﻿(function () {
    angular.module("WizdomMobileModule").factory("settingsApi", settingsApi);
    settingsApi.$inject = ["$q", "wcmStarterHttpApi"];
    var settings = {};
    function settingsApi($q, httpApi) {

        var baseUrl = '/api/settings/';
        function getModuleSettings(module) {
            return settings[module] ? $q.when(settings[module]) : httpApi.get(baseUrl + module).then(function (data) {
                settings[module] = data;
                return data;
            });
        }
        function saveModuleSettings(module, moduleSettings) {
            if (settings[module]) {
                settings[module] = moduleSettings; /* Update cached settings */
            }
            return httpApi.post(baseUrl + module, moduleSettings);
        }
        var service = {
            getSettings: getModuleSettings,
            saveSettings: saveModuleSettings
        };
        return service;
    }
})();