﻿(function () {
    angular.module("WizdomMobileModule").factory("notificationService", notificationService);

    
    notificationService.$inject = ["$timeout"];

    function notificationService($timeout) {
        var service = {
            showErrorMessage: showErrorMessage,
            showWarningMessage: showWarningMessage,
            showSuccessMessage: showSuccessMessage,
            showConfirmationDialog: showConfirmationDialog
        };

        return service;

        function showErrorMessage(text, autoClose, canClose) {
            if (angular.isUndefined(autoClose)){autoClose = true;}
            if (angular.isUndefined(canClose)){canClose = true;}
                
            var n = noty({
                text: text,
                layout: 'topCenter',
                type: 'error',
                animation: {
                    open: 'animated flipInX', // Animate.css class names
                    close: 'animated flipOutX' // Animate.css class names
                },
                closeWith: canClose ? ["click"] : []
            });

            if (autoClose)
                $timeout(function(){
                    $.noty.close(n.options.id);
                }, 6000);
        }


        function showWarningMessage(text, autoClose, canClose) {
            if (angular.isUndefined(autoClose)){autoClose = true;}
            if (angular.isUndefined(canClose)){canClose = true;}

                var n = noty({
                    text: text,
                    layout: 'topCenter',
                    type: 'warning',
                    animation: {
                        open: 'animated flipInX', // Animate.css class names
                        close: 'animated flipOutX' // Animate.css class names
                    },
                    closeWith: canClose ? ["click"] : []
                });

                if (autoClose)
                    $timeout(function() {
                        $.noty.close(n.options.id);
                    }, 6000);
            }

                function showSuccessMessage(text, autoClose, canClose) {
                    if (angular.isUndefined(autoClose)) { autoClose = true; }
                    if (angular.isUndefined(canClose)) { canClose = true; }

                    var n = noty({
                        text: text,
                        layout: 'topCenter',
                        type: 'success',
                        animation: {
                            open: 'animated flipInX', // Animate.css class names
                            close: 'animated flipOutX' // Animate.css class names
                        },
                        closeWith: canClose ? ["click"] : []
                    });

                    if (autoClose)
                        $timeout(function(){
                            $.noty.close(n.options.id);
                        }, 6000);
                }

                    function showConfirmationDialog(config) {
                        /// <summary>Shows swcmse dialog with type defined</summary>
                        /// <param name="config.text" type="String">
                        ///     Text that is shown within the dialog
                        /// </param>
                        /// <param name="config.modal" type="Bool">
                        ///     Specefies whether is current dialog a modal
                        /// </param>
                        /// <param name="config.type" type="String">
                        ///     Can be of type: alert, information, error, warning, notification, success
                        /// </param>
                        /// <param name="config.layout" type="String">
                        ///     Indicates where to  show dialog
                        ///     Can be of type: top, topCenter, topLeft, topRight,
                        ///     center, centerRight, centerLeft,
                        ///     bottom, bottomCenter, bottomRight, bottomLeft
                        /// </param>
                        /// <param name="config.successCalback" type="Object">
                        ///     Success callback
                        /// </param>
                        /// <param name="config.cancelCalback" type="Object">
                        ///     Error callback
                        /// </param>
                        var okBtnTxt = (config.okButtonText) ? config.okButtonText : "Ok",
                            cancelBtnTxt = (config.cancelButtonText) ? config.cancelButtonText : "Cancel";
                        var n = noty({
                            text: config.text,
                            type: config.type,
                            dismissQueue: true,
                            layout: config.layout,
                            theme: 'defaultTheme',
                            modal: config.modal || true,
                            buttons: [
                                {
                                    addClass: 'btn btn-primary',
                                    text: okBtnTxt,
                                    onClick: function($noty) {
                                        $noty.close();

                                        if (config.successCalback) {
                                            config.successCalback();
                                        }
                                    }
                                },
                                {
                                    addClass: 'btn btn-danger',
                                    text: cancelBtnTxt,
                                    onClick: function($noty) {
                                        $noty.close();

                                        if (config.cancelCalback) {
                                            config.cancelCalback();
                                        }
                                    }
                                }
                            ]
                        });
                    }
                }
})();