﻿(function () {
    angular.module("WizdomMobileModule").filter("translate", translate);
    translate.$inject = ["translations"];
    function translate(translations) {
        var Wizdom = window["Wizdom"];
        var language = Wizdom && Wizdom.getCurrentLanguage ? Wizdom.getCurrentLanguage() : 'da-dk';

        return function (translationId, interpolateParams, interpolation) {
            var arguments = angular.isArray(interpolateParams) ? interpolateParams :
                angular.isObject(interpolateParams) ? interpolateParams :
                    angular.isDefined(interpolateParams) ? [interpolateParams] : [];
            var rtnVal = (translations[language] == null || !translations[language][translationId]) ? translationId : translations[language][translationId];
            angular.forEach(arguments, function (value, index) {
                rtnVal = rtnVal.replace('{ ' + index + '}', value || '');
            });
            return rtnVal;
        }
    }
})();
