﻿(function () {

    angular.module("WizdomMobileModule").controller("noticeboardController", noticeboardController);
    noticeboardController.$inject = ["$scope", "$timeout", "settingsApi", "noticeboardService"];
    function noticeboardController($scope, $timeout, settingsApi, noticeboardService) {
        var vm = this;

        // Properties
        vm.noticeboardSettings;
        vm.channelSets = [];
        vm.saving = false;

        // Load settings
        settingsApi.getSettings('NewsNoticeboard').then(function (response) {
            vm.noticeboardSettings = response;
        });

        // Load available noticeboard channelsets
        noticeboardService.getChannelSets().then(function (response) {
            vm.channelSets = response;
        });

        // Public methods
        vm.saveSettings = saveSettings;
        vm.saveViewConfiguration = saveViewConfiguration;

        // Private methods
        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

        function saveViewConfiguration() {
            var data = {
                "id": "e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4",
                "channelSetId": vm.noticeboardSettings.channelSetId,
                "deviceId": 1,
                "deviceIdentifier": "Webpart",
                "sharedChannelSet": true,
                "extendedProperties": {
                    "itemsPerPage": vm.noticeboardSettings.itemsPerPage,
                    "maxNumberOfPages": 1, //vm.noticeboardSettings.maxNumberOfPages,
                    "defaultSelection": "All",
                    "hideToolbar": false,
                    "archiveUrl": null,
                    "overviewTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/Overview/WizdomMobileModule_Overview_Default.html",
                    "showItemTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/ShowItem/WizdomMobileModule_Show_Default.html",
                    "createEditNewsTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/NewEditForm/WizdomMobileModule_CreateAndEdit.html",
                    "createEditVideoTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/NewEditForm/WizdomMobileModule_CreateAndEdit.html"
                },
                "editAllowedForCurrentUser": false
            };
            noticeboardService.getViewById('e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4').then(function (response) {
                if (response.views.count > 0) {
                    // update existing view
                    noticeboardService.putViewById('e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4', data);
                }
                else {
                    // create new view
                    noticeboardService.postViewById('e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4', data);
                }
            });

        }
    }

})();