﻿(function () {

    angular.module("WizdomMobileModule").controller("LogController", LogController);

    
    LogController.$inject = ["$scope", "administrationApi", "log"];

    function LogController($scope, administrationApi, log) {
        $scope.logEntries = [];
        $scope.loading = true;
        $scope.sortColumn = 'timestamp';
        $scope.sortReverse = false;
        $scope.status = "";
        $scope.millisec = "";
        $scope.module = "";
        $scope.message = "";

        var yellowThreshold = 500;
        var redThreshold = 2000;

        $scope.filterLog = filterLog;
        $scope.getBackground = getBackground;

        $scope.clearLog = function () {
            log("Clean Log!");
            administrationApi.clearLog().then(function (data) {
                log("Log cleaned!");
                init();
            });
        }

        init();

        function filterLog(item) {
            return ($scope.status == "" || item.level == $scope.status) && // status
                ($scope.millisec == "" || ($scope.millisec < 0 && item.timeTaken < 0 - $scope.millisec) || ($scope.millisec > 0 && item.timeTaken > $scope.millisec)) && // millisec
                ($scope.module == "" || (item.module != null && item.module.indexOf($scope.module) >= 0)) && //module
                ($scope.message == "" || item.text.indexOf($scope.message) >= 0) // message
        }

        function getBackground(timeTaken) {
            if (timeTaken >= yellowThreshold) {
                var red = timeTaken >= yellowThreshold ? 255 : timeTaken / yellowThreshold * 255;
                var green = timeTaken <= yellowThreshold ? 255 : timeTaken > redThreshold ? 0 : (redThreshold - timeTaken) / 1500 * 255;
                var blue = 0;
                return "'background-color:rgb(" + Math.round(red) + "," + Math.round(green) + "," + Math.round(blue) + ")'";
            }
            return "";
        }

        function init() {
            log("Get logs!");
            administrationApi.getLogs().then(function (data) {
                log("Logs retrivied!");
                $scope.logEntries = data;
                $scope.loading = false;
            }
            );
        }
    }

})();