﻿(function () {
    angular.module("WizdomMobileModule").controller("navigationAdminController", navigationAdminController);

    navigationAdminController.$inject = ["$scope", "$timeout", "settingsApi", "$modal", "defaultNavigation"];

    function navigationAdminController($scope, $timeout, settingsApi, $modal, defaultNavigation) {

        // Properties

        // Load settings
        settingsApi.getSettings('navigation').then(function (response) {

            $scope.settings = response;
            $scope.tabs = $scope.settings.tabs;

            if (!Array.isArray($scope.tabs)) {
                $scope.tabs = $scope.settings.tabs = angular.copy(defaultNavigation);
            }
        });

        // Public methods
        $scope.editTab = function (tab) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/Navigation/Templates/NavigationEditTemplate.html',
                controller: 'navigationEditController as navigationEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editTabObjMaster: function () { return tab; }
                }
            }).result.then(function (data) {
                var index = $scope.tabs.indexOf(data.editTabObjMaster);
                angular.copy(data.editTabObj, $scope.tabs[index]);
                $scope.saveSettings('navigation', $scope.settings);
            });
        };

        $scope.saveSettings = function (componentName, settings) {
            $scope.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    $scope.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };       
    }

})();