﻿(function () {

    angular.module("WizdomMobileModule").controller("focusArticleAdminController", focusArticleAdminController);

    focusArticleAdminController.$inject = ["$scope", "$window", "$modal", "newsService", "settingsApi", "contextInfo", "$timeout", "$http"];

    function focusArticleAdminController($scope, $window, $modal, newsService, settingsApi, contextInfo, $timeout, $http) {
        var vm = this;

        // Properties
        vm.newsRowLimit = 10;
        vm.contentPageRowLimit = 5;
        vm.spHostUrl = contextInfo.spHostUrl;
        vm.settings = {}
        vm.focusTypeOptions = ["News article", "Content page", "URL"];
        
        init();

        // Public methods        
        vm.focusArticleEnabled = focusArticleEnabled;
        vm.chosenType = chosenType;
        vm.setFocus = setFocus;
        vm.newsFocus = newsFocus;
        vm.contentPageFocus = contentPageFocus;

        // Private methods
        function init() {

            // Load settings
            settingsApi.getSettings('FocusArticle').then(function (response) {
                if (jQuery.isEmptyObject(response)) {
                    vm.settings.newsArticle = {};
                    vm.settings.url = {};
                    vm.settings.contentPage = {};
                    vm.settings.enabledComponent = false;
                    vm.settings.focusSetTo = null;
                    vm.saveSettings();
                } else {
                    vm.settings = response;
                }

                if (vm.settings.focusSetTo)
                    vm.selectedType = vm.settings.focusSetTo;

            });

            articles();
            contentPages();
        }

        function contentPageFocus(item) {

            if (item.marked) {
                angular.forEach(vm.contentPages.contentPagesCollection, function (e, i) {
                    if (e.guid !== item.guid) {
                        e.marked = false;
                    }
                });

                vm.settings.contentPage.link = "internal://contentpageviewer({contentpageguid:'" + item.guid + "'})";
                vm.settings.contentPage.isFocus = item.marked;
            }

            setFocus("Content page", vm.settings.contentPage, item);
        }

        function newsFocus(item) {
            if (item.marked) {

                angular.forEach(vm.news, function (e, i) {
                    if (e.guid !== item.guid) {
                        e.marked = false;
                    }
                });
                
                vm.settings.newsArticle.guid = item.guid;
                vm.settings.newsArticle.isFocus = item.marked;


            }
            setFocus("News article", vm.settings.newsArticle, item);
           
        }
        //Set scope variable to which type is in focus
        function setFocus(type, settingTypeObject, item) {

            if (vm.settings.focusSetTo === null || vm.settings.focusSetTo === undefined) {
                vm.settings.focusSetTo = type; 
            } else {
                //isFocus value is set on ng-model before the ng-change function is called
                if (vm.settings.focusSetTo !== type && settingTypeObject.isFocus) {
                    var confirm = $window.confirm("A focus page is already set. Are you sure you want to change it?");

                    if (confirm) {
                        vm.settings.focusSetTo = type;
                        isFocusHelper(type);
                        markedHelper();
                    } else if (type === "News article" || type === "Content page") {
                        item.marked = false;
                        settingTypeObject.isFocus = false;

                    } else {
                        settingTypeObject.isFocus = false;
                    }
                }
                else {
                    
                    settingTypeObject.isFocus = false;
                }
            }
            
            
        }       

        function contentPages() {
            settingsApi.getSettings('ContentPages').then(function (data) {
                vm.contentPages = data;
                vm.contentPages.contentPagesCollection = vm.contentPages.contentPagesCollection || [];
            });
        }

        function articles() {
            newsService.getLatest(10, 0).then(function (data) {
                vm.news = data;
                markedHelper();                
                
            }, function (error) {});
        }

        function chosenType() {

            switch (vm.selectedType) {
                case "News article":
                    
                    break;

                case "Content page":

                    break;

                case "URL":

                    break;

                default:
                    break;
            }
        }

        function focusArticleEnabled() {
            vm.saveSettings();
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

        // Helper functions

        function markedHelper() {

            switch (vm.settings.focusSetTo) {
                case "News article":
                    loopHelperNews(true);
                    loopHelperContentPages(false);
                    break;

                case "Content page":
                    loopHelperContentPages(true);
                    loopHelperNews(false);
                    break;
                default:
                    loopHelperContentPages(false);
                    loopHelperNews(false);
                    break;

            };         

            function loopHelperNews(bool) {

                angular.forEach(vm.news, function (e, i) {
                    if (e.guid === vm.settings.newsArticle.guid) {
                        e.marked = bool;
                    }
                });
            }

            function loopHelperContentPages(bool) {
                angular.forEach(vm.contentPages.contentPagesCollection, function (e, i) {
                    if ("internal://contentpageviewer({contentpageguid:'" + e.guid + "'})" === vm.settings.contentPage.link) {
                        e.marked = bool;
                    }
                });
            }
        }

        function isFocusHelper(type) {
            switch (type) {
                case "News article":
                    vm.settings.url.isFocus = false;
                    vm.settings.contentPage.isFocus = false;
                    break;

                case "Content page":
                    vm.settings.newsArticle.isFocus = false;
                    vm.settings.url.isFocus = false;
                    break;

                case "URL":
                    vm.settings.newsArticle.isFocus = false;
                    vm.settings.contentPage.isFocus = false;
                    break;

                default:
                    break;
            }
        }
    }
})();
