﻿(function () {
    angular.module('WizdomMobileModule').controller('peopleController', peopleController);

    peopleController.$inject = ['$scope', '$timeout', '$compile', '$http', '$window', '$state', 'peopleSettings', 'graphService', 'spinnerService'];
    function peopleController($scope, $timeout, $compile, $http, $window, $state, peopleSettings, graphService, spinnerService) {

        // Properties
        $scope.suggestedPeople = [];
        $scope.managedProperties = peopleSettings.managedProperties || ['About-me'];
        $scope.enableSuggestedPeople = peopleSettings.enableSuggestedPeople || false;
        $scope.resultSourceId = peopleSettings.resultSourceId || 'b09a7990-05ea-4af9-81ef-edfab16c4e31';
        $scope.error = false;

        // Private methods
        function initialize() {
            // Init device spinner
            spinnerService.startSpinner();

            // Add people directory 
            injectPeopleDirectory();

            // Retrieve suggested people from MS Graph API
            graphService.getListPeople().then(function (response) {
                $scope.suggestedPeople = response;
                spinnerService.stopSpinner();
            }).catch(function (e) {
                $scope.error = true;
                spinnerService.stopSpinner();
            });
        }
        initialize();

        function injectPeopleDirectory() {
            var elementWrapper = angular.element('#WizdomPeopleDirectoryWrapper');
            if (elementWrapper.length !== 0) {
                elementWrapper.append($compile('<div wizdom365-phonebook webpart-properties=\'{"webpartInstanceId": "68d60e82-66a8-4f94-a4ae-79409ce5c504", "searchTemplateUrl": "Phonebook/Templates/ViewTemplates/SearchTemplates/WizdomMobileModule_Search.html", "resultTemplateUrl": "Phonebook/Templates/ViewTemplates/ResultTemplates/WizdomMobileModule_Results.html", "numberOfUsersPerPage": 20, "paging": "None", "resultSource": "' + $scope.resultSourceId + '", "userProperties": ' + JSON.stringify($scope.managedProperties) + ' }\'></div>')($scope));
            }
            else {
                $timeout(function () {
                    injectPeopleDirectory();
                }, 100);
            }
        }

    }
})();