﻿(function () {
    angular.module('WizdomMobileModule').controller("focusImageController", ["$scope", "focusArticleSettings", "newsService", "settingsApi", "wcmStarterModuleConfiguration",
        function ($scope, focusArticleSettings, newsService, settingsApi, wcmStarterModuleConfiguration) {

            $scope.appUrl = wcmStarterModuleConfiguration.appUrl;

            fetchAndDisplay(focusArticleSettings);

            function fetchAndDisplay(response) {
                if (response.focusSetTo !== null) {
                    switch (response.focusSetTo) {
                        case "News article":
                            newsService.getSpecific(response.newsArticle.guid).then(function (data) {
                                if (data.length > 0) {
                                    $scope.focusArticle = {
                                        "focusItem": {
                                            "guid": data[0].UniqueId,
                                            "title": data[0].Title,
                                            "summary": data[0].W365NewsSummaryOWSHTML === null ? "" : data[0].W365NewsSummaryOWSHTML.split('>')[1].split('<')[0],
                                            "imagePath": data[0].PublishingImage === null ? "" : data[0].PublishingImage.split(" ")[2].split('"')[1],
                                            "url": data[0].Path,
                                            "date": data[0].LastModifiedTime
                                        },
                                        "enabledComponent": response.enabledComponent,
                                        "focusSetTo": response.focusSetTo
                                    }
                                }

                            }, function (error) { console.log(error); });
                            break;
                        case "Content page":
                            if (response.contentPage.link.indexOf("http") === -1) {
                                var guid = response.contentPage.link.split("{")[1].split("'")[1];
                                settingsApi.getSettings("ContentPages").then(function (data) {
                                    angular.forEach(data.contentPagesCollection, function (e, i) {
                                        if (e.guid === guid) {
                                            $scope.focusArticle = {
                                                "focusItem": {
                                                    "guid": e.guid,
                                                    "title": e.title,
                                                    "summary": e.summary,
                                                    "imagePath": e.imagePath,
                                                    "url": response.contentPage.link
                                                },
                                                "enabledComponent": response.enabledComponent,
                                                "focusSetTo": response.focusSetTo
                                            }

                                        }
                                    });
                                });
                            } else {
                                console.log("ERROR: Focus article set to Content Page. Wrong url in link property.");
                            }

                            break;
                        case "URL":
                            $scope.focusArticle = {
                                "focusItem": {
                                    "title": response.url.title,
                                    "summary": response.url.summary,
                                    "imagePath": response.url.imagePath,
                                    "url": response.url.url
                                },
                                "enabledComponent": response.enabledComponent,
                                "focusSetTo": response.focusSetTo
                            }
                            break;
                        default:
                            break;
                    }
                }

            }

        }]
    );
})();