﻿(function () {
    angular.module('WizdomMobileModule').controller("displayNewsController", ["$scope", "$window", "$state", "$stateParams", "$q", "corporateNewsApi", "newsService", "corporateNewsSettings", "latestNewsSettings", "trendingNewsSettings", "wizdomSocialService", "spinnerService",
        function ($scope, $window, $state, $stateParams, $q, corporateNewsApi, newsService, corporateNewsSettings, latestNewsSettings, trendingNewsSettings, wizdomSocialService, spinnerService) {

            // Properties
            $scope.news = [];
            $scope.type = $stateParams.type;

            // Public methods
            $scope.openArticle = openArticle;

            // Private methods
            function initialize() {
                // Check if settings are available
                if (Object.keys(corporateNewsSettings).length !== 0 && corporateNewsSettings.constructor === Object) {
                    switch ($scope.type) {
                        case 'home-latest':
                            getLatestForHome();
                            break;
                        case 'latest':
                            getLatest();
                            break;
                        case 'trending':
                            getTrending();
                            break;
                        default:
                            getLatest();
                            break;
                    }
                }
                else {
                    // Missing configuration
                    $scope.warning = true;
                    $scope.message = "Please configure the Corporate News.";
                }
                

            }
            initialize();

            function getLatestForHome() {
                getWizdomCorporateNews(latestNewsSettings.homeRowLimit, null, null);
            }

            function getLatest() {
                // Init device spinner
                spinnerService.startSpinner();
                getWizdomCorporateNews(null, null, null);
            }

            function getTrending() {
                // Init device spinner
                spinnerService.startSpinner();
                getWizdomCorporateNews(null, 'ViewsRecent', false);
            }

            function getWizdomCorporateNews(rowLimit, orderBy, ascending) {      
                // Always use SharePoint Search Based. CAML is NOT supported.
                corporateNewsApi.getNews(
                    corporateNewsSettings.path,
                    rowLimit || corporateNewsSettings.numberOfNews,
                    corporateNewsSettings.typeNews,
                    orderBy || corporateNewsSettings.orderBy,
                    ascending || corporateNewsSettings.ascending,
                    corporateNewsSettings.cachingType,
                    corporateNewsSettings.resultSource,
                    corporateNewsSettings.selectProperties,
                    corporateNewsSettings.languageFilterUseDynamic ? corporateNewsSettings.languageFilterDynamic : corporateNewsSettings.languageFilter.map(e => e.label).join(';'),
                    corporateNewsSettings.departmentFilterUseDynamic ? corporateNewsSettings.departmentFilterDynamic : corporateNewsSettings.departmentFilter.map(e => e.label).join(';'),
                    corporateNewsSettings.locationFilterUseDynamic ? corporateNewsSettings.locationFilterDynamic : corporateNewsSettings.locationFilter.map(e => e.label).join(';'),
                    corporateNewsSettings.languageFilterUseDynamic,
                    corporateNewsSettings.departmentFilterUseDynamic,
                    corporateNewsSettings.locationFilterUseDynamic,
                    corporateNewsSettings.includeModernNews,
                    corporateNewsSettings.pathModern,
                    corporateNewsSettings.includeClassicNews,
                )
                    .then(function (response) {
                        var queue = [];
                        for (i = 0; i < response.length; i++) {
                            queue.push(getSocial(response[i]));
                        }
                        return $q.all(queue);
                    })
                    .then(function (data) {
                        try {
                            for (var i = 0; i < data.length; i++) {
                                data[i].date = wizdom365FormatDate(data[i].date);
                            }
                        } catch (error) {
                            console.log(error);
                        }
                        $scope.news = data;
                        spinnerService.stopSpinner();

                    });
            }

            function getSocial(item) {
                return wizdomSocialService.getSocialOverview(item.extendedProperties.listItemId + '%7B' + item.extendedProperties.listID + '%7D', 3).then(function (response) {
                    item["likes"] = response.likes;
                    item["comments"] = response.comments;
                    item["socialItem"] = response;
                    item["socialItemId"] = item.extendedProperties.listItemId + '{' + item.extendedProperties.listID + '}';
                    return $.when(item);
                }, function (response) {
                    return $.when(item);
                });
            }

            function openArticle(item) {
                switch ($scope.type) {
                    case 'home-latest':
                        $state.go('home.article', { id: item.extendedProperties.listItemId, item: item, type: $scope.type }, { reload: 'home.article' });
                        break;
                    case 'latest':
                        $state.go('news.article', { id: item.extendedProperties.listItemId, item: item, type: $scope.type }, { reload: 'news.article' });
                        break;
                    case 'trending':
                        $state.go('news.article', { id: item.extendedProperties.listItemId, item: item, type: $scope.type }, { reload: 'news.article' });
                        break;
                    default:
                        $state.go('news.article', { id: item.extendedProperties.listItemId, item: item, type: $scope.type }, { reload: 'home.article' });
                        break;
                }
            }

            function wizdom365FormatDate(dateString) {
                var timestamp = Date.parse(dateString + 'Z');
                if (isNaN(timestamp)) {
                    return new Date(dateString);
                } else {
                    return new Date(timestamp);
                }
            }

            // Handle image renditions +++
            $scope.stateName = $state.current.name;

            $scope.imageRendition = {
                width: 375,
                height: 328
            };

            if ($window.innerWidth > 400) {
                $scope.imageRendition = {
                    width: 750,
                    height: 656
                };
            }
               
        }]
    );
})();