﻿(function () {
    angular.module('WizdomMobileModule').controller('navigationController', ['$scope', '$state', 'settingsApi',
        function ($scope, $state, settingsApi) {
            settingsApi.getSettings('AppMenuBuilder').then(function (data) {
                $scope.navigationItem = data;
            });

            settingsApi.getSettings('navigation').then(function (data) {
                $scope.showNavigation = data.enableLegacyNavigation && !window.invokeCSharpAction;
                $scope.tabs = data.tabs;
                for (const tab of data.tabs) {
                    if (window.location.href.includes(tab.altUrl || tab.defaultUrl)) {
                        $scope.activeTab = tab.defaultName;
                        //break; //Note: We can't break here - we need to run through all - the first tab will always match, we need to look for any additional matches...
                    }
                } 
            });

            $scope.activateTab = function (tab) {
                $scope.activeTab = tab.defaultName;
                window.location.assign(tab.altUrl || tab.defaultUrl);
            };
        }
    ]);
})();