﻿(function () {
    angular.module('WizdomMobileModule').factory('wizdomSocialService', wizdomSocialService);
    wizdomSocialService.$inject = ['$window', 'wcmStarterHttpApi', 'webApiProxy', 'contextInfo'];

    function wizdomSocialService($window, httpApi, webApiProxy, contextInfo) {

        var baseUrl = contextInfo.appUrl;

        // COMMENTS AND LIKES
        // Get
        function getSocialOverview(itemId, type) {
            //return httpApi.get(baseUrl + '/api/wizdom/corporateNews/social/overview/' + listId + '/' + itemId + '?webServerRelativeUrl=' + url).then(function (response) {
            //    return response;
            //});
            // Use webApiProxy instead, since the other endpoint doesn't work as expected
            return webApiProxy.social.getSocialOverview(itemId, type).then(function (response) {
                return response;
            });
        }

        var service = {
            getSocialOverview: getSocialOverview
        };

        return service;
    }
})();