﻿(function () {
    angular.module('WizdomMobileModule').factory('graphService', graphService);
    graphService.$inject = ['$q', '$http', '$window', 'wcmStarterHttpApi'];

    function graphService($q, $http, $window, httpApi) {

        // MICROSOFT GRAPH API SERVICE

        // Social intelligence: People
        function getListPeople() {
            var deferred = $q.defer();

            var upn = $window.localStorage.getItem('currentUserUPN');
            if (upn == null) {
                $http.get($window._spPageContextInfo.webAbsoluteUrl + '/_api/SP.UserProfiles.PeopleManager/GetMyProperties').then(function (response) {
                    upn = response.data.UserProfileProperties.find(function (p) { return p.Key === 'SPS-UserPrincipalName'; }).Value;
                    $window.localStorage.setItem('currentUserUPN', upn);
                    deferred.resolve(upn);
                }, function (response) {
                    deferred.reject(response);
                });
            } else {
                deferred.resolve(upn)
            }

            return deferred.promise.then(function (upn) {
                return httpApi.get('/api/Graph/SuggestedPeople?userPrincipalName=' + encodeURIComponent(upn));
            });
        }

        var service = {
            getListPeople: getListPeople
        };

        return service;
    }
})();