﻿(function () {
    angular.module('WizdomMobileModule').controller('mobileSocialPanelController', mobileSocialPanelController);
    mobileSocialPanelController.$inject = ['$scope', '$window', 'wcmStarterHttpApi', 'webApiProxy', 'contextInfo'];

    function mobileSocialPanelController($scope, $window, httpApi, webApiProxy, contextInfo) {

        // Properties
        $scope.likedByCurrentUser = false;
        $scope.targetTotalComments = 0;

        // Public methods
        $scope.likeItem = likeItem;

        // Private methods
        function initialize() {
            // Check if liked by currentuser
            if (typeof $scope.item !== 'undefined' && $scope.item !== null) {
                var isLiked = $scope.item.likes.some(function (element) {
                    return element.principal.loginName.toLowerCase() === $window._spPageContextInfo.userLoginName.toLowerCase(); // contextInfo.userLoginName.toLowerCase();
                });
                $scope.likedByCurrentUser = isLiked;
                $scope.targetTotalComments = $scope.item.comments.length;
            }
        }
        initialize();

        function likeItem() {
            var likeDto = {
                'principal': { loginName: contextInfo.userLoginName, displayName: contextInfo.displayName },
                'targetID': $scope.itemId.toString(),
                'targetType': $scope.itemType // 1: item, 2: comment , 3: corporateNews , 4: manualPage, 5: contentPage
            };

            webApiProxy.social.likeItem(likeDto)
                .then(results => {
                    if (!results)
                        return;

                    $scope.likedByCurrentUser = !$scope.likedByCurrentUser;
                    if ($scope.likedByCurrentUser)
                        $scope.item.likes.push(likeDto);
                    else {
                        var index = $scope.item.likes.findIndex(like => like.principal.loginName.toLowerCase() === contextInfo.userLoginName.toLowerCase());
                        if (index !== -1) {
                            $scope.item.likes.splice(index, 1);
                        }
                    }
                });
        }

        // Watchers
        $scope.$watch('item', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                initialize();
            }
        }, true);
    }
})();