(function () {
    angular.module('WizdomMobileModule').directive('detectScroll', detectScroll);

    detectScroll.$inject = ['$http', '$window', 'wcmStarterHttpApi', 'contextInfo'];
    function detectScroll($http, $window, wcmStarterHttpApi, contextInfo) {
        return {
            scope: {
                delta: '='
            },
            link: function (scope, element, attributes) {
                var detectScroll;
                var delta = 5;
                var lastScrollTop = 0;
                scope.animateNav = false;
    
                // noticeboard
    
                // todo: move to directive for news nav
                angular.element($window).bind("scroll", function () {
                    detectScroll = true;
                });
                setInterval(function() {
                if (detectScroll) {
                    hasScrolled();
                    detectScroll = false;
                }
                }, 500);
    
                function hasScrolled() {
                    var scroll = angular.element(window).scrollTop()
    
                    if (Math.abs(lastScrollTop - scroll) <= delta)
                        return
    
                    if (scroll > lastScrollTop && scroll > element.outerHeight()) {
                        element.removeClass('down').addClass('up')
                    } else if (scroll + angular.element($window).height() < angular.element(document).height()) {
                        element.removeClass('up').addClass('down')
                    }
                    lastScrollTop = scroll;
                } // end of scroll
            }
        };
    }
})();